#!/usr/bin/env python3
###############################################################################
## vim: et ai ts=4
##
## Bitte erst ab der Stelle im Code, die mit 'Hier beginnt Ihr Code' markiert
## ist, eigenen Code einfuegen.

###############################################################################

Aufgabe = 12                    # Diesen Eintrag nicht veraendern,
                               # anderenfalls wird die Aufgabe nicht gewertet!!

Studenten = []                 # Initalisierung der Studentenliste

###############################################################################
## Bitte tragen Sie in die folgenden Variablen Ihre Gruppennummer und die
## Mitglieder Ihrer Gruppe ein. Bitte verwenden Sie KEINE Umlaute!

Gruppennummer = 3
# Syntax fuer die Angabe der Namen und Matrikelnummern der einzelen
# Gruppenmitglieder:
#
Studenten.append({'matnr':34653, 'nachname':"Haug", 'vorname':"Martin"})
# Studenten.append({'matnr':12346, 'nachname':"NACHNAME2", 'vorname':"VORNAME2"})
# Studenten.append({'matnr':12347, 'nachname':"NACHNAME3", 'vorname':"VORNAME3"})
# Studenten.append({'matnr':12348, 'nachname':"NACHNAME4", 'vorname':"VORNAME4"})
# Studenten.append({'matnr':12349, 'nachname':"NACHNAME5", 'vorname':"VORNAME5"})

###############################################################################
## Code fuer Aufgabe

# Importieren der fehlerhaften Queues
from Queue import Queue1, Queue2, Queue3, Queue4, Queue5, Queue6, Queue7, Queue8

# Importiere Funktionen um Dateien zu pruefen
import os.path
import types

API = ["empty", "full", "enqueue", "dequeue"]

QUEUES = ["Queue1", "Queue2", "Queue3", "Queue4", "Queue5", "Queue6", "Queue7", "Queue8"]


def load_stream(filename):
    assert isinstance(filename, str)
    assert os.path.isfile(filename)

    stream = []
    with open(filename, 'r') as fil:
        for line in fil:
            entry = line.strip().split(" ")

            # dont append empty lines
            if len(entry) == 0:
                continue

            #check for valid commands
            if entry[0] not in  ["#"] + API + QUEUES:
                return ["# ungueltiger Eintrag in der Datei"]

            # check for valid argument
            if entry[0] == "enqueue" and \
               (len(entry) < 2 or \
               (not entry[1].isdecimal() and \
               not entry[1][1:].isdecimal())):
                return ["# ungueltiger Eintrag in der Datei"]

            if entry[0] in QUEUES and \
               (len(entry) < 2 or \
               (not entry[1].isdecimal())):
                return ["# ungueltiger Eintrag in der Datei"]

            # Entry has right structure
            stream.append(" ".join(entry))

    return stream


def store_stream(stream, filename):
    assert isinstance(stream, list)
    assert isinstance(filename, str)

    # allow only storing in current directory
    assert filename.find("/") == -1
    assert filename.find("\\") == -1

    try:
        with open(filename, "w") as fil:
            for line in stream:
                fil.write(line + "\n")
    except Exception:
        pass


def run_stream(stream):
    # # Wenn der Testlauf ohne Fehler gelaufen ist:
    # return []
    # # Wenn der Testlauf mit einem Fehler abbricht, dann
    # # hängen sie an stream die folgende Zeile an
    # stream.append(["#", "Test aborted in line: %d" % (index)])
    # # wobei stream[index] den API call liefert, der abgebrochen ist.
    # return stream
    # # Wenn in der Struktur von stream etwas nicht stimmt:
    # return None
    assert isinstance(stream, list)
    for entry in stream:
        assert isinstance(entry, str)

    vgl_queue = []
    queue_size = None
    try:
        for lnr in range(len(stream)):
            line = stream[lnr].split(" ")
            if line[0] == "#":
                continue

            if line[0] in QUEUES:
                # check requirements for well formed stream and API call
                if len(line) == 2 and \
                   line[1].isdecimal() and \
                   int(line[1]) > 0 and \
                   queue_size == None:

                    # initialize queue
                    queue = eval("%s(%s)" % (line[0], line[1]))

                    # initialize vgl_queue
                    queue_size = int(line[1])

                    # always call check_rep
                    queue.check_rep()
                else:
                    return None
            elif line[0] in API and queue_size == None:
                # queue not initialized
                return None
            elif line[0] in API and line[0] == "empty":
                res = queue.empty()
                assert (len(vgl_queue) == 0) == res
                queue.check_rep()
            elif line[0] in API and line[0] == "full":
                res = queue.full()
                assert (len(vgl_queue) == queue_size) == res
                queue.check_rep()
            elif line[0] in API and line[0] == "enqueue":
                if not ((len(line) == 2) and (line[1].isdecimal() or \
                        (line[1][0] == "-" and line[1][1:].isdecimal()))):
                    # invalid argument for enqueue
                    return None
                res = queue.enqueue(int(line[1]))
                if len(vgl_queue) < queue_size:
                    vgl_queue.append(int(line[1]))
                    assert res
                else:
                    assert not res
                queue.check_rep()
            elif line[0] in API and line[0] == "dequeue":
                res = queue.dequeue()
                if len(vgl_queue) > 0:
                    vgl_val = vgl_queue.pop(0)
                    assert res == vgl_val
                else:
                    assert res == None
            else:
                # Invalid api call
                return None
    except AssertionError:
        # stream.append("# Test aborted in line: %d" % (lnr))
        return stream
    except:
        print (lnr)
        return None
    else:
        return []


def ddmin(s):
    assert test(s) == "FAIL"

    n = 2 
    while len(s) >= 2:
        start = 0
        subset_length = int(len(s) / n)
        some_complement_is_failing = False

        while start < len(s):
            complement = s[:start] + s[start + subset_length:]

            if test(complement) == "FAIL":
                s = complement
                n = max(n - 1, 2)
                some_complement_is_failing = True
                break
                
            start += subset_length

        if not some_complement_is_failing:
            if n == len(s):
                break
            n = min(2 * n, len(s))

    return s


#############################################################
## Hier beginnt Ihr Code

def minimize_all():
    for queue in QUEUES:
        load_filename = "test_%s" % (queue)
        store_filename = "test_min_%s" % (queue)
        print(load_filename)
        
        try:
            with open(load_filename,"r"):
                testcasestr = load_stream(load_filename)
            testcasestr = ddmin(testcasestr)
            if test(testcasestr) == "FAIL":
                store_stream(testcasestr,store_filename)
        except IOError:
            print("Die Datei %s existiert nicht" % load_filename)
        
        # Benutzen Sie die Funktionen:    
        #   load_stream
        #   store_stream
        #   run_stream
        #   ddmin
        #
        # Aufgabe:
        # Falls die Datei load_filename existiert,
        # dann minimieren Sie den Testfall und
        # Speichern das Ergebnis in die Datei
        # store_filename


def test(s):
    assert(isinstance(s,list))
    
    erg = run_stream(s)
    assert(isinstance(erg,list) or erg == None)
    if erg != None and len(erg)>0:
        return "FAIL"
    else:
        return "PASS"
        


###############################################################################
## Bitte erst innerhalb des folgenden if Blocks Funktionen aufrufen.
## Werden ausserhalb dieses Blocks Funktionen aufgerufen, so wird die Aufgabe
## nicht gewertet.

if __name__ == '__main__':

    ## Der folgende Funktionsaufruf prueft die Eintraege der Variablen
    ## Studenten, Gruppennummer und Aufgabe und gibt die Werte tabelarisch
    ## auf dem Bildschirm aus oder loest einen Fehler aus, falls die Form
    ## der Eintraege nicht korrekt ist.
    from Grading.Grading import *
    Grading.CheckStudents(Studenten, Gruppennummer, Aufgabe)

    ## Aufruf der Testfunktion
    minimize_all()
    print("fertig")
