var pp_hessen = {
	ksl: {
		offset: 1,
		title: "Kreis Kassel",
		lines: [
			"25 Piraten",
			"1 Pirat im Kreistag",
			"<a href='http://www.piratenpartei-kassel.de/mitmachen'>Mit- und Neupiraten gesucht</a>",
		]
	},
	ks: {
		offset: 2,
		title: "Kassel",
		lines: [
			"41 Piraten",
			"2 Piraten in der StaVo",
			"<a href='http://www.piratenpartei-kassel.de/mitmachen'>Kreisverband</a>",
		]
	},
	wmk: {
		offset: 3,
		title: "Werra-Meißner-Kreis",
		lines: [
			"5 Piraten",
			"<a href='http://lists.piratenpartei-hessen.de/mailman/listinfo/werra-meissner-kreis'>Mit- und Neupiraten gesucht</a>",
		]
	},
	wfb: {
		offset: 4,
		title: "Kreis Waldeck-Frankenberg",
		lines: [
			"18 Piraten",
			"1 Pirat im Kreistag",
			"<a href='http://piraten-waldeck-frankenberg.de'>Kreisverband</a>",
		]
	},
	sek: {
		offset: 5,
		title: "Schwalm-Eder-Kreis",
		lines: [
			"17 Piraten",
			"<a href='http://lists.piratenpartei-hessen.de/mailman/listinfo/werra-meissner-kreis'>Mit- und Neupiraten gesucht</a>",
		]
	},
	hr: {
		offset: 6,
		title: "Kreis Hersfeld-Rotenburg",
		lines: [
			"8 Piraten",
			"<a href='http://lists.piratenpartei-hessen.de/mailman/listinfo/hef'>Mit- und Neupiraten gesucht</a>",
		]
	},
	mr: {
		offset: 7,
		title: "Kreis Marburg-Biedenkopf",
		lines: [
			"39 Piraten",
			"1 Pirat in der StaVo",
			"1 Pirat im Kreistag",
			"<a href='http://www.piratenpartei-marburg.de/mitmachen'>Kreisverband</a>",
		]
	},
	vb: {
		offset: 8,
		title: "Kreis Vogelsberg",
		lines: [
			"11 Piraten",
			"<a href='http://lists.piratenpartei-hessen.de/mailman/listinfo/vogelsberg'>Mit- und Neupiraten gesucht</a>",
		]
	},
	fd: {
		offset: 9,
		title: "Kreis Fulda",
		lines: [
			"12 Piraten",
			"<a href='http://www.piraten-fulda.de'>Stammtisch</a>",
			"<a href='http://lists.piratenpartei-hessen.de/mailman/listinfo/fulda'>Mit- und Neupiraten gesucht</a>",
		]
	},
	ldk: {
		offset: 10,
		title: "Lahn-Dill-Kreis",
		lines: [
			"15 Piraten",
			"<a href='http://lists.piratenpartei-hessen.de/mailman/listinfo/lahn-dill-kreis'>Mit- und Neupiraten gesucht</a>",
		]
	},
	gi: {
		offset: 11,
		title: "Gießen",
		lines: [
			"28 Piraten",
			"<a href='http://www.piraten-giessen.de/stadtfraktion'>Stadtfraktion</a>",
			"<a href='http://www.piraten-giessen.de/kreistagsabgeordnete'>2 Piraten im Kreistag</a>",
			"<a href='http://www.piraten-giessen.de/mitmachen'>Kreisverband</a>",
		]
	},
	fb: {
		offset: 12,
		title: "Kreis Wetterau",
		lines: [
			"47 Piraten",
			"1 Pirat im Kreistag",
			"<a href='http://www.piratenpartei-wetterau.de'>Kreisverband</a>",
		]
	},
	mkk: {
		offset: 13,
		title: "Main-Kinzig-Kreis",
		lines: [
			"48 Piraten",
			"<a href='http://www.kinzigpiraten.de/kreistag'>Kreistagsfraktion</a>",
			"<a href='http://www.kinzigpiraten.de'>Kreisverband</a>",
		]
	},
	lw: {
		offset: 14,
		title: "Kreis Limburg-Weilburg",
		lines: [
			"13 Piraten",
			"<a href='http://lists.piratenpartei-hessen.de/mailman/listinfo/limburg-weilburg'>Mit- und Neupiraten gesucht</a>",
		]
	},
	htk: {
		offset: 15,
		title: "Hochtaunuskreis",
		lines: [
			"45 Piraten",
			"1 Pirat im Kreistag",
			"<a href='http://www.piratenpartei-hochtaunus.de'>Kreisverband</a>",
		]
	},
	ffm: {
		offset: 16,
		title: "Frankfurt am Main",
		lines: [
			"147 Piraten",
			"Fraktion ELF Piraten",
			"<a href='http://www.piratenpartei-frankfurt.de'>Kreisverband</a>",
		]
	},
	of: {
		offset: 17,
		title: "Offenbach am Main",
		lines: [
			"22 Piraten",
			"Stadtfraktion",
			"<a href='http://www.piratenpartei-offenbach.de'>Stammtisch</a>",
			"<a href='http://lists.piratenpartei-hessen.de/mailman/listinfo/kreis-of'>Mit- und Neupiraten gesucht</a>",
		]
	},
	kof: {
		offset: 18,
		title: "Kreis Offenbach",
		lines: [
			"64 Piraten",
			"<a href='http://www.kreispiraten-of.de/content/fraktion-piraten-im-kreistag-offenbach-land'>Kreistagsfraktion</a>",
			"<a href='http://www.kreispiraten-of.de'>Kreisverband</a>",
		]
	},
	rtk: {
		offset: 19,
		title: "Rheingau-Taunus-Kreis",
		lines: [
			"19 Piraten",
			"<a href='http://lists.piratenpartei-hessen.de/mailman/listinfo/wiesbaden'>Mit- und Neupiraten gesucht</a>",
		]
	},
	wi: {
		offset: 20,
		title: "Wiesbaden",
		lines: [
			"71 Piraten",
			"<a href='http://linke-und-piraten-wiesbaden.de'>Fraktion LINKE&PIRATEN",
			"<a href='http://www.piratenpartei-wiesbaden.de'>Kreisverband</a>",
		]
	},
	mtk: {
		offset: 21,
		title: "Main-Taunus-Kreis",
		lines: [
			"32 Piraten",
			"<a href='http://www.piraten-mtk.de'>Stammtisch</a>",
			"<a href='http://lists.piratenpartei-hessen.de/mailman/listinfo/mtk'>Mit- und Neupiraten gesucht</a>",
		]
	},
	gg: {
		offset: 22,
		title: "Kreis Gross-Gerau",
		lines: [
			"27 Piraten",
			"<a href='http://www.piratenpartei-gross-gerau.de'>Stammtisch</a>",
			"<a href='http://lists.piratenpartei-hessen.de/mailman/listinfo/gross-gerau'>Mit- und Neupiraten gesucht</a>",
		]
	},
	da: {
		offset: 23,
		title: "Darmstadt",
		lines: [
			"63 Piraten",
			"Stadtfraktion",
			"<a href='http://www.piratenpartei-dadadi.de'>Kreisverband</a>",
		]
	},
	dadi: {
		offset: 24,
		title: "Kreis Darmstadt-Dieburg",
		lines: [
			"42 Piraten",
			"Fraktion Freie Wähler - Piraten",
			"<a href='http://www.piratenpartei-dadadi.de'>Kreisverband</a>",
		]
	},
	bs: {
		offset: 25,
		title: "Kreis Bergstrasse",
		lines: [
			"41 Piraten",
			"1 Pirat im Kreistag",
			"<a href='http://www.piraten-bergstrasse.de'>Kreisverband</a>",
		]
	},
	ow: {
		offset: 26,
		title: "Kreis Odenwald",
		lines: [
			"12 Piraten",
			"<a href='http://lists.piratenpartei-hessen.de/mailman/listinfo/odenwaldkreis'>Mit- und Neupiraten gesucht</a>",
		]
	},
};

var pp_hessen_clicked = "";

$(document).ready(function() {
	$("#pp_hessen_regionClose").hide();
	$("#pp_hessen_regionClose").click(function() {
		pp_hessen_clicked = "";
		pp_hessen_outHessen();
		$("#pp_hessen_regionClose").hide();
	});
	if (pp_hessen_default != 0)
		pp_hessen_outHessen();
});

function pp_hessen_outHessen() {
	if (pp_hessen_clicked == "") {
		$("#pp_hessen_karteHessen").css({backgroundPosition: "0 -"+229*pp_hessen_default+"px"});
		$("#pp_hessen_regionTitle").html("");
		$("#pp_hessen_regionLine1").html("");
		$("#pp_hessen_regionLine2").html("");
		$("#pp_hessen_regionLine3").html("");
		$("#pp_hessen_regionLine4").html("");
	} else {
		pp_hessen_clickHessen(pp_hessen_clicked);
	}
}

function pp_hessen_overHessen(region) {
	pp_hessen_showTile(region);
	if (region != pp_hessen_clicked)
		$("#pp_hessen_regionClose").hide();
}

function pp_hessen_clickHessen(region) {
	pp_hessen_clicked = region;
	pp_hessen_showTile(region);
	$("#pp_hessen_regionClose").show();
}

function pp_hessen_showTile(region) {
	$("#pp_hessen_karteHessen").css({backgroundPosition: "0 -"+229*pp_hessen[region].offset+"px"});
	$("#pp_hessen_regionTitle").html(pp_hessen[region].title ? pp_hessen[region].title : "");
	$("#pp_hessen_regionLine1").html(pp_hessen[region].lines[0] ? pp_hessen[region].lines[0] : "");
	$("#pp_hessen_regionLine2").html(pp_hessen[region].lines[1] ? pp_hessen[region].lines[1] : "");
	$("#pp_hessen_regionLine3").html(pp_hessen[region].lines[2] ? pp_hessen[region].lines[2] : "");
	$("#pp_hessen_regionLine4").html(pp_hessen[region].lines[3] ? pp_hessen[region].lines[3] : "");
}
