<?php

/**
 * Admin menu page for the basic settings
 */
function pp_socialshareprivacy_admin_form() {
  $form = array();

  $form['pp_socialshareprivacy_facebook_account'] = array(
    '#type' => 'fieldset',
    '#title' => t('Facebook Einstellungen'),
    '#description' => t('Ein Facebook Konto ist notwendig, um den Empfehlen-Button verwenden zu können.<br>Um eine App ID zu erhalten, muss man leider ein zertifizierter Entwickler sein und eine <a href="https://developers.facebook.com/docs/reference/plugins/like/">App bei Facebook</a> erstellen.'),
    '#collapsible' => TRUE,
    '#collapsed' => FALSE,
  );

  $form['pp_socialshareprivacy_facebook_account']['pp_socialshareprivacy_fb_app_id'] = array(
    '#type' => 'textfield',
    '#title' => t('Die Facebook App ID'),
    '#default_value' => variable_get('pp_socialshareprivacy_fb_app_id', NULL),
  );

  $form['pp_socialshareprivacy_node_widget_settings'] = array(
    '#type' => 'fieldset',
    '#title' => t('Inhaltstypen Einstellungen'),
    '#description' => t('Es können keine, eine oder mehrere Inhaltstypen ausgewählt werden.'),
    '#collapsible' => TRUE,
    '#collapsed' => FALSE,
  );

  $form['pp_socialshareprivacy_node_widget_settings']['pp_socialshareprivacy_content_types'] = array(
    '#type' => 'fieldset',
    '#title' => t('Content types'),
    '#collapsible' => FALSE,
  );

  $form['pp_socialshareprivacy_node_widget_settings']['pp_socialshareprivacy_content_types']['pp_socialshareprivacy_node_types'] = array(
    '#type' => 'checkboxes',
    '#options' => node_type_get_names(),
    '#default_value' => variable_get('pp_socialshareprivacy_node_types', array('story')),
  );

  return system_settings_form($form);
}
