#!/usr/bin/perl -w

use strict;
use POSIX;

# Sucht im Wiki nach dem Stammtisch-Fenster und ersetzt das Datum von gestern durch das von in 6 Tagen
# Vorsicht bei Zeitumstellung: gestern wird mit -86400 Sekunden berechnet
#
# bentigt curl wegen multipart-post
# ja, da gibt's sicher irgendein perl-Modul dazu ...

if(!defined($ARGV[2]) || $ARGV[2] eq "")
{
  print("Usage: $0 <page> <last date is n days ago> <next date is n days from now>\n");
  print("Example: $0 Landkreis_Freising/Stammtisch 1 6\n");
  exit 1;
}

my $page_url=$ARGV[0];
my $days_ago=int($ARGV[1]);
my $days_to_go=int($ARGV[2]);

my $base_url="http://wiki.piratenpartei.de";
my $agent="Stammtischbot_0.11";
my $cookies="/tmp/stammtisch.cookie.$$";
my $working_file="/tmp/stammtisch.working.$$";
my $url;
my $textarea;
my $last=strftime("%Y-%m-%d", localtime(time()-86400*$days_ago));
my $next=strftime("%Y-%m-%d", localtime(time()+86400*$days_to_go));

my $auto_summary;
my $edit_token;
my $login_token;

my $user="Hans";
my $pass="Wurst";

unlink("$cookies");

# Spaghetti-Code tut's auch
# Los geht's
# Anmelden

$url="${base_url}/wiki//index.php?title=Spezial:Anmelden&returnto=${page_url}";
$textarea=`curl -b $cookies -c $cookies -0 -A \"$agent\" -s \"${url}\" `;
if($textarea =~ m/name="wpLoginToken" value="([^"]*)"/)
{
  $login_token=$1;
  $login_token=~s/\\/\\\\/;
}
else
  {die("kein loginToken\n");}

system("curl -b $cookies -c $cookies -0 -A \"$agent\" -s -o ${working_file} --data-urlencode \"wpName=${user}\" --data-urlencode \"wpPassword=${pass}\" --data-urlencode \"wpLoginattempt=Anmelden\" --data-urlencode \"wpLoginToken=${login_token}\" \"${url}\"");

# Seite holen
$url="${base_url}/wiki//index.php?title=${page_url}&action=edit";
$textarea=`curl -b $cookies -c $cookies -0 -A \"$agent\" -s \"${url}\"`;
#if($textarea =~ m/wpAutoSummary.*?value="([^"]*)"/)
#  {$auto_summary=$1;}
#else
#  {die("kein wpAutoSummary\n");}
if($textarea =~ m/value="([^"]*)" name="wpEditToken"/)
{
  $edit_token=$1;
  $edit_token=~s/\\/\\\\/;
}
else
  {die("kein editToken\n");}
# Mll weg
$textarea=~s/.*?<textarea.*?>(.*?)<\/textarea.*/$1/s;

#HTML nach text wandeln
$textarea =~ s/&amp;/&/g;
$textarea =~ s/&lt;/</g;
$textarea =~ s/&gt;/>/g;
$textarea =~ s/&quot;/\"/g;

# Datum tauschen
if($textarea=~s/( |Datum=   )${last}(\n |Datumsformat=1\n |Tag=     )/$1${next}$2/sm)
{
  # Hochladen
  $url="${base_url}/wiki//index.php?title=${page_url}&action=submit";
  open(FH, "|curl -o ${working_file} -b $cookies -c $cookies -0 -A \"$agent\" -s -F wpSection= -F wpStarttime= -F wpEdittime= -F wpScrolltop=0 -F wpTextbox1=0 -F \"wpSummary=Stammtisch-Bot freut sich auf ${next}\" -F 'wpSave=Seite speichern' -F \"wpEditToken=$edit_token\" -F 'wpTextbox1=<-' \"${url}\"");
  print FH $textarea;
  close(FH);
  print("Stammtisch gendert von ${last} auf ${next}\n");
}
else
{
  unlink("$cookies");
  print("Couldn't find date $last\n");
}

# Abmelden
$url="${base_url}/wiki//index.php?title=Spezial:Abmelden&returnto=${page_url}";
$textarea=`curl -b $cookies -c $cookies -0 -A \"$agent\" -s \"${url}\"`;


unlink("$cookies");
