#!/usr/bin/env python3
###############################################################################
## vim: et ai ts=4
##
## Bitte erst ab der Stelle im Code, die mit 'Hier beginnt Ihr Code' markiert
## ist, eigenen Code einfuegen.

###############################################################################

Aufgabe = 6                    # Diesen Eintrag nicht veraendern,
                               # anderenfalls wird die Aufgabe nicht gewertet!!

Studenten = []                 # Initalisierung der Studentenliste

###############################################################################
## Bitte tragen Sie in die folgenden Variablen Ihre Gruppennummer und die
## Mitglieder Ihrer Gruppe ein. Bitte verwenden Sie KEINE Umlaute!

Gruppennummer = 1
# Syntax fuer die Angabe der Namen und Matrikelnummern der einzelen
# Gruppenmitglieder:
#
Studenten.append({'matnr':34653, 'nachname':"Haug", 'vorname':"Martin"})
# Studenten.append({'matnr':12346, 'nachname':"NACHNAME2", 'vorname':"VORNAME2"})
# Studenten.append({'matnr':12347, 'nachname':"NACHNAME3", 'vorname':"VORNAME3"})
# Studenten.append({'matnr':12348, 'nachname':"NACHNAME4", 'vorname':"VORNAME4"})
# Studenten.append({'matnr':12349, 'nachname':"NACHNAME5", 'vorname':"VORNAME5"})

###############################################################################
## Code fuer Aufgabe

# Importieren der fehlerhaften Queues
from Queue import Queue, Queue1, Queue2, Queue3, Queue4, Queue5, Queue6, Queue7, Queue8

# Importiere Funktionen um Dateien zu pruefen
import os.path

# Import random Funktionen
import random

# Import time Funktionen fuer seed
from time import time

import re

API = ["empty", "full", "enqueue", "dequeue"]

#QUEUES = ["Queue1", "Queue2", "Queue3", "Queue4", "Queue5", "Queue6", "Queue7", "Queue8"]
QUEUES = ["Queue3", "Queue6"]


def create_random_api_calls(api=None, queues=None, queue_size=None, max_queue_size=2000, stream_length=None, max_stream_length=16000, seed=None):
    assert (api == None) or isinstance(api, list)
    assert (queues == None) or isinstance(queues, list)
    assert (queue_size == None) or (isinstance(queue_size, int) and queue_size > 0)
    assert isinstance(max_queue_size, int) and max_queue_size > 0
    assert (stream_length == None) or (isinstance(stream_length, int) and stream_length > 0)
    assert isinstance(max_stream_length, int) and max_stream_length > 0
    assert (seed == None) or isinstance(seed, int)

    # Set default for lists
    if api == None:
        api = API

    if queues == None:
        queues = QUEUES

    # create seed from time if not given otherwise
    if seed == None:
        seed = int(time() * 10000)

    # initialize random generator
    random.seed(seed)

    stream = []

    # store call parameter
    stream.append(["#", "api = '%s'" % ("', '".join(api))])
    stream.append(["#", "queues = '%s'" % ("', '".join(queues))])
    stream.append(["#", "queue_size = %s" % (repr(queue_size))])
    stream.append(["#", "max_queue_size = %s" % (repr(max_queue_size))])
    stream.append(["#", "stream_length = %s" % (repr(stream_length))])
    stream.append(["#", "max_stream_length = %s" % (repr(max_stream_length))])
    stream.append(["#", "seed = %s" % (repr(seed))])

    # choose queue implementation
    queue = random.choice(queues)

    # choose size of queue
    random_queue_size = random.randint(1, max_queue_size)
    if queue_size == None:
        queue_size = random_queue_size

    # store / call chosen queue and its length
    stream.append([str(queue), str(queue_size)])

    # choose stream_length
    random_stream_length = random.randint(1, max_stream_length)
    if stream_length == None:
        stream_length = random_stream_length

    # store chosen stream_length
    stream.append(["#", "chosen stream_length = %s" % (repr(stream_length))])

    for call in range(stream_length):
        api_call = random.choice(api)

        # only enqueue requires a second argument
        if api_call == "enqueue":
            value = random.randint(-2 ** 31, 2 ** 31)
            stream.append([str(api_call), str(value)])
        else:
            stream.append([str(api_call)])

    return stream


def store_stream(stream, filename):
    assert isinstance(stream, list)
    assert isinstance(filename, str)

    # allow only storing in current directory
    assert filename.find("/") == -1
    assert filename.find("\\") == -1

    try:
        with open(filename, "w") as fil:
            for line in stream:
                fil.write(" ".join(line) + "\n")
    except Exception:
        pass


def load_stream(filename):
    assert isinstance(filename, str)
    assert os.path.isfile(filename)

    stream = []

    # # Enthaelt die zu ladende Datei Eintraege, die nicht mit Elementen aus
    # # API, QUEUES oder mit "#" beginnenen oder deren API Benutzung unglueltig
    # # ist (falsche Argumente etc.) dann soll die Funktion das folgende
    # # zurueckgeben:
    # return [["#", "ungueltiger Eintrag in der Datei"]]
    # # Anderenfalls, wird der eingelesene Datenstrom zurueckgegenen.

    try:
        with open(filename, "r") as datei:
            for line in datei:
                if (line in API and line.match(r"((\w+ \w+)|(enqueue \w+ \w+))\Z")) \
                    or (line in QUEUES) or (line.startswith('#')) :
                #if (line.strip() in API and line.strip().match(r"(\w+ \w+)|(enqueue \w+ \w+)"))
                #    or (line.strip() in QUEUES) or (line.strip().startswith('#')):
                    stream.append(line.split(" "))
                #else:
                    return [["#", "ungueltiger Eintrag in der Datei"]]
            return stream
    except Exception:
        pass


    return stream


def run_stream(stream):
    assert isinstance(stream, list)
    for line in stream:
        assert isinstance(line, list)
        for entry in line:
            assert isinstance(entry, str)

    try:
        #stream = []

        lnr = 0  # Hier soll jeweils die Nummer der ausgefuehrten Zeile stehen
        
        testqueue = None
        refqueue = None
        for line in stream:
            lnr+=1
            if line[0] == "#": #Kommentare überspringen
                continue
            else:
                if re.match(r"Queue\d\Z", line[0]):
                    testqueue = eval(line[0]+"("+line[1]+")")
                    refqueue = Queue(int(line[1]))
                else:
                   testret = eval("testqueue."+line[0]+"("+(line[1] if len(line)>1 else "")+")") #Statement auf zu testender Queue ausführen
                   refret  = eval("testqueue."+line[0]+"("+(line[1] if len(line)>1 else "")+")") #Statement Referenzimplementation ausführen
                   assert testret == refret, "Die zu testende Queue lieferte ein anderes Ergebnis als die Referenzimplementation"
                   testqueue.check_rep()

    except AssertionError:
        # Der Lauf dieses Streams hat einen Fehler gefunden
        stream.append(["#", "Test aborted in line: %d" % (lnr)])
        return stream
    except Exception as err:
        # Ein unerwarteter Fehler ist aufgetreten.
        print(err)
        return None
    else:
        return []

    # # Wenn der Testlauf ohne Fehler gelaufen ist:
    # return []
    # # Wenn der Testlauf mit einem Fehler abbricht, dann
    # # haengen sie an stream die folgende Zeile an
    # stream.append(["#", "Test aborted in line: %d" % (index)])
    # # wobei stream[index] den API call liefert, der abgebrochen ist.
    # return stream
    # # Wenn in der Struktur von stream etwas nicht stimmt:
    # return None


def main_run():
    for queue in QUEUES:
        print("Create and run tests for %s: " % (queue), end="")
        for i in range(30):
            stream = create_random_api_calls(queues=[queue])
            result = run_stream(stream)
            if result == None:
                print("X", end="")
                stream.append(["#", "Faulty API stream"])
                store_stream(stream, "test_%s" % (queue))
                break
            elif len(result) == 0:
                print(".", end="")
            else:
                print("F", end="")
                store_stream(result, "test_%s" % (queue))
                break
        print("\n")


def load_all_run():
    for queue in QUEUES:
        print("Load and run test for %s: " % (queue), end="")
        if not os.path.isfile("test_%s" % (queue)):
            print("no testcase stored!")
            continue
        stream = load_stream("test_%s" % (queue))
        result = run_stream(stream)
        if result == None:
            print("X", end="")
        elif len(result) == 0:
            print(".", end="")
        else:
            print("F", end="")
        print("\n")

###############################################################################
## Bitte erst innerhalb des folgenden if Blocks Funktionen aufrufen.
## Werden ausserhalb dieses Blocks Funktionen aufgerufen, so wird die Aufgabe
## nicht gewertet.

if __name__ == '__main__':

    ## Der folgende Funktionsaufruf prueft die Eintraege der Variablen
    ## Studenten, Gruppennummer und Aufgabe und gibt die Werte tabelarisch
    ## auf dem Bildschirm aus oder loest einen Fehler aus, falls die Form
    ## der Eintraege nicht korrekt ist.
    from Grading.Grading import *
    Grading.CheckStudents(Studenten, Gruppennummer, Aufgabe)

    ## Aufruf der Testfunktion
    main_run()
    # Falls Sie für Queue3 keinen API Strom erzeugen können, dann implementiren
    # Sie, an main_run() orientiert die Folgende Funktion, die den
    # create_random_api_calls() aufruf aus den schriftlichen Aufgabe 2.1.3
    # enthält.
    # main_run_Queue3_tweek()
    load_all_run()
