\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{piratehandout}[2013/08/08 Pirate handout class]

\LoadClass[a4paper,12pt,twoside,onecolumn,final]{article}

\RequirePackage[hmargin=2cm,vmargin=1cm,includeheadfoot,
                headheight=41pt,headsep=12pt,footskip=60pt]{geometry}

\RequirePackage{pgf}
\pgfdeclareimage[height=48pt]{informieren}{PiratenInformieren}
\pgfdeclareimage[height=36pt]{signet}{PiratenSignet}

\RequirePackage{fancyhdr}
\pagestyle{fancy}
\fancyhf{}
\renewcommand{\headrulewidth}{0pt}
\renewcommand{\footrulewidth}{0pt}
\fancyhead[OR,EL]{\pgfuseimage{signet}}
\fancyfoot[OR,EL]{\it\thepage/\pageref{lastpage}}
\fancypagestyle{plain}{ %
  \fancyhf{}
  \renewcommand{\headrulewidth}{0pt}
  \renewcommand{\footrulewidth}{0pt}
  \fancyfoot[OR,EL]{\pgfuseimage{informieren}}
}

\RequirePackage[defaultmathsizes]{mathastext}
\RequirePackage[no-math]{fontspec}
\setmainfont[ItalicFont=DejaWeb-Italic.ttf, BoldFont=DejaWeb-Bold.ttf,
             BoldItalicFont=DejaWeb-BoldItalic.ttf]{DejaWeb.ttf}
\newfontface\politics[ItalicFont=PoliticsHead.otf, BoldFont=PoliticsHead.otf,
                      BoldItalicFont=PoliticsHead.otf]{PoliticsHead.otf}

\renewcommand{\maketitle}{%
    \vspace*{-53pt}%
    {\centering\politics\LARGE \@title}%
    \par%
    \thispagestyle{plain}}

\renewcommand\section{\@startsection{section}{1}{\z@}%
                                    {-1ex \@plus -1ex \@minus -.2ex}%
                                    {.3ex \@plus.2ex}%
                                    {\politics\large}}
\renewcommand\subsection{\@startsection{subsection}{2}{\z@}%
                                       {-1ex\@plus -1ex \@minus -.2ex}%
                                       {.2ex \@plus .2ex}%
                                       {\politics\large}}
\renewcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
                                          {-1ex\@plus -1ex \@minus -.2ex}%
                                          {.2ex \@plus .2ex}%
                                          {\politics\normalsize}}
\renewcommand\paragraph{\@startsection{paragraph}{4}{\z@}%
                                      {1ex \@plus1ex \@minus.2ex}%
                                      {-1em}%
                                      {\politics\normalsize}}
\renewcommand\subparagraph{\@startsection{subparagraph}{5}{\parindent}%
                                       {1ex \@plus1ex \@minus .2ex}%
                                       {-1em}%
                                       {\politics\normalsize}}

\RequirePackage{enumitem}
\setlist{nolistsep}

\AtEndDocument{\label{lastpage}}
