#$Rev: 10193 $ all.
data <- read.csv("survey_925538_R_data_file.csv", quote = "'\"", na.strings=c("", "\"\""), stringsAsFactors=FALSE)

# LimeSurvey Field type: F
data[, 1] <- as.numeric(data[, 1])
attributes(data)$variable.labels[1] <- "id"
names(data)[1] <- "id"

# LimeSurvey Field type: DATETIME23.2
data[, 2] <- as.character(data[, 2])
attributes(data)$variable.labels[2] <- "submitdate"
names(data)[2] <- "submitdate"

#Field hidden

# LimeSurvey Field type: A
data[, 3] <- as.character(data[, 3])
attributes(data)$variable.labels[3] <- "startlanguage"
names(data)[3] <- "startlanguage"

#Field hidden

# LimeSurvey Field type: F
data[, 4] <- as.numeric(data[, 4])
attributes(data)$variable.labels[4] <- "[Umfassende AnträgeWP118 – Mehr DemokratieWP161 – Sammelantrag Demokratie] Möchtest du, dass die folgenden Themen aus dem Bereich \"Demokratie wagen\" behandelt werden?"
data[, 4] <- factor(data[, 4], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[4] <- "q_01_1"

# LimeSurvey Field type: F
data[, 5] <- as.numeric(data[, 5])
attributes(data)$variable.labels[5] <- "[BundestagswahlrechtWP156 – Bundestagswahlrechtsvorschlag von Mehr Demokratie e.V. ins WahlprogrammWP036 – Konzept für ein neues BundestagswahlrechtWP121 – Bundeswahlrecht grundlegend reformieren: für Mehrmandatswahlkreise, offene Listen und AlternativstimmenWP148 – Wahlrecht ohne Altersbegrenzung] Möchtest du, dass die folgenden Themen aus dem Bereich \"Demokratie wagen\" behandelt werden?"
data[, 5] <- factor(data[, 5], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[5] <- "q_01_2"

# LimeSurvey Field type: F
data[, 6] <- as.numeric(data[, 6])
attributes(data)$variable.labels[6] <- "[MitbestimmungWP002 – Einführung bundesweiter VolksentscheideWP146 – Kein ESM und keine EU-Verfassung ohne Referendum] Möchtest du, dass die folgenden Themen aus dem Bereich \"Demokratie wagen\" behandelt werden?"
data[, 6] <- factor(data[, 6], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[6] <- "q_01_3"

# LimeSurvey Field type: F
data[, 7] <- as.numeric(data[, 7])
attributes(data)$variable.labels[7] <- "[TransparenzWP063 – Unabhängigkeit der Abgeordneten] Möchtest du, dass die folgenden Themen aus dem Bereich \"Demokratie wagen\" behandelt werden?"
data[, 7] <- factor(data[, 7], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[7] <- "q_01_4"

# LimeSurvey Field type: F
data[, 8] <- as.numeric(data[, 8])
attributes(data)$variable.labels[8] <- "[SubsidiaritätWP125 – Subsidiarität in der Kultur- und Sozialpolitik] Möchtest du, dass die folgenden Themen aus dem Bereich \"Demokratie wagen\" behandelt werden?"
data[, 8] <- factor(data[, 8], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[8] <- "q_01_6"

# LimeSurvey Field type: F
data[, 9] <- as.numeric(data[, 9])
attributes(data)$variable.labels[9] <- "[SonstigesWP048 – Effiziente Antragsaussprache] Möchtest du, dass die folgenden Themen aus dem Bereich \"Demokratie wagen\" behandelt werden?"
data[, 9] <- factor(data[, 9], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[9] <- "q_01_7"

# LimeSurvey Field type: F
data[, 10] <- as.numeric(data[, 10])
attributes(data)$variable.labels[10] <- "[Antrag WP] Nenne bis zu 4 Anträge aus dem Themenbereich \"Demokratie wagen\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[10] <- "q_02_1"

# LimeSurvey Field type: F
data[, 11] <- as.numeric(data[, 11])
attributes(data)$variable.labels[11] <- "[Antrag WP] Nenne bis zu 4 Anträge aus dem Themenbereich \"Demokratie wagen\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[11] <- "q_02_2"

# LimeSurvey Field type: F
data[, 12] <- as.numeric(data[, 12])
attributes(data)$variable.labels[12] <- "[Antrag WP] Nenne bis zu 4 Anträge aus dem Themenbereich \"Demokratie wagen\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[12] <- "q_02_3"

# LimeSurvey Field type: F
data[, 13] <- as.numeric(data[, 13])
attributes(data)$variable.labels[13] <- "[Antrag WP] Nenne bis zu 4 Anträge aus dem Themenbereich \"Demokratie wagen\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[13] <- "q_02_4"

# LimeSurvey Field type: F
data[, 14] <- as.numeric(data[, 14])
attributes(data)$variable.labels[14] <- "[Umfassende AnträgeWP060 – Gesamtantrag zu Kapitel 13: Innen- und RechtspolitikWP168 – Sammelantrag Innen- und Rechtspolitik] Möchtest du, dass die folgenden Themen aus dem Bereich \"Innen- und Rechtspolitik\" behandelt werden?"
data[, 14] <- factor(data[, 14], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[14] <- "q_01_1"

# LimeSurvey Field type: F
data[, 15] <- as.numeric(data[, 15])
attributes(data)$variable.labels[15] <- "[Staat und ReligionWP069 – Trennung von Staat und ReligionWP062 – Trennung von Staat und KircheWP167 – Weltanschauliche Neutralität des Staates herstellen: Kirchliche Feiertage] Möchtest du, dass die folgenden Themen aus dem Bereich \"Innen- und Rechtspolitik\" behandelt werden?"
data[, 15] <- factor(data[, 15], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[15] <- "q_01_2"

# LimeSurvey Field type: F
data[, 16] <- as.numeric(data[, 16])
attributes(data)$variable.labels[16] <- "[VerfassungsschutzWP073 – Abschaffung des Bundesamtes für VerfassungsschutzWP127 – Abschaffung des Verfassungsschutzes] Möchtest du, dass die folgenden Themen aus dem Bereich \"Innen- und Rechtspolitik\" behandelt werden?"
data[, 16] <- factor(data[, 16], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[16] <- "q_01_3"

# LimeSurvey Field type: F
data[, 17] <- as.numeric(data[, 17])
attributes(data)$variable.labels[17] <- "[SonstigesWP061 – Das Namensrecht liberalisierenWP065 – Anonymisierung des zentralen nationalen WaffenregistersWP025 – Pressefreiheit schützen durch strafbewehrtes Verbot der BehinderungWP066 – Kein Alkoholverbot auf öffentlichen Plätzen] Möchtest du, dass die folgenden Themen aus dem Bereich \"Innen- und Rechtspolitik\" behandelt werden?"
data[, 17] <- factor(data[, 17], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[17] <- "q_01_4"

# LimeSurvey Field type: F
data[, 18] <- as.numeric(data[, 18])
attributes(data)$variable.labels[18] <- "[Antrag WP] Nenne bis zu 4 Anträge aus dem Themenbereich \"Innen- und Rechtspolitik\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[18] <- "q_02_1"

# LimeSurvey Field type: F
data[, 19] <- as.numeric(data[, 19])
attributes(data)$variable.labels[19] <- "[Antrag WP] Nenne bis zu 4 Anträge aus dem Themenbereich \"Innen- und Rechtspolitik\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[19] <- "q_02_2"

# LimeSurvey Field type: F
data[, 20] <- as.numeric(data[, 20])
attributes(data)$variable.labels[20] <- "[Antrag WP] Nenne bis zu 4 Anträge aus dem Themenbereich \"Innen- und Rechtspolitik\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[20] <- "q_02_3"

# LimeSurvey Field type: F
data[, 21] <- as.numeric(data[, 21])
attributes(data)$variable.labels[21] <- "[Antrag WP] Nenne bis zu 4 Anträge aus dem Themenbereich \"Innen- und Rechtspolitik\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[21] <- "q_02_4"

# LimeSurvey Field type: F
data[, 22] <- as.numeric(data[, 22])
attributes(data)$variable.labels[22] <- "[Vision für EuropaWP133 – EU-Sixpack] Möchtest du, dass die folgenden Themen aus dem Bereich \"Europa\" behandelt werden?"
data[, 22] <- factor(data[, 22], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[22] <- "q_01_1"

# LimeSurvey Field type: F
data[, 23] <- as.numeric(data[, 23])
attributes(data)$variable.labels[23] <- "[Fiskalunion und ESMWP111 – Transparenz und demokratische Kontrolle des ESMWP080 – Schulden- Guthabenkrise wirksam lösenWP079 – Europas Schulden-/Guthabenkrise wirksam lösen - Bankenrekapitalisierung] Möchtest du, dass die folgenden Themen aus dem Bereich \"Europa\" behandelt werden?"
data[, 23] <- factor(data[, 23], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[23] <- "q_01_2"

# LimeSurvey Field type: F
data[, 24] <- as.numeric(data[, 24])
attributes(data)$variable.labels[24] <- "[ZeitumstellungWP076 – EU-weite Abschaffung der Zeitumstellung] Möchtest du, dass die folgenden Themen aus dem Bereich \"Europa\" behandelt werden?"
data[, 24] <- factor(data[, 24], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[24] <- "q_01_3"

# LimeSurvey Field type: F
data[, 25] <- as.numeric(data[, 25])
attributes(data)$variable.labels[25] <- "[Antrag WP] Nenne bis zu 2 Anträge aus dem Themenbereich \"Europa\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[25] <- "q_02_1"

# LimeSurvey Field type: F
data[, 26] <- as.numeric(data[, 26])
attributes(data)$variable.labels[26] <- "[Antrag WP] Nenne bis zu 2 Anträge aus dem Themenbereich \"Europa\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[26] <- "q_02_2"

# LimeSurvey Field type: F
data[, 27] <- as.numeric(data[, 27])
attributes(data)$variable.labels[27] <- "[Umfassende AnträgeWP170 – Sammelantrag Aussenpolitik] Möchtest du, dass die folgenden Themen aus dem Bereich \"Außenpolitik\" behandelt werden?"
data[, 27] <- factor(data[, 27], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[27] <- "q_01_1"

# LimeSurvey Field type: F
data[, 28] <- as.numeric(data[, 28])
attributes(data)$variable.labels[28] <- "[EntwicklungspolitikWP024 – Für eine solidarische und transparente Entwicklungszusammenarbeit] Möchtest du, dass die folgenden Themen aus dem Bereich \"Außenpolitik\" behandelt werden?"
data[, 28] <- factor(data[, 28], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[28] <- "q_01_2"

# LimeSurvey Field type: F
data[, 29] <- as.numeric(data[, 29])
attributes(data)$variable.labels[29] <- "[VerteidigungspolitikWP022 – Verteidigungspolitisches Konzept der Piratenpartei, orientiert am Status Quo] Möchtest du, dass die folgenden Themen aus dem Bereich \"Außenpolitik\" behandelt werden?"
data[, 29] <- factor(data[, 29], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[29] <- "q_01_3"

# LimeSurvey Field type: F
data[, 30] <- as.numeric(data[, 30])
attributes(data)$variable.labels[30] <- "[PräambelWP010 – Friedenslogik statt Sicherheitslogik, Präambel-Vorschlag Außenpolitik] Möchtest du, dass die folgenden Themen aus dem Bereich \"Außenpolitik\" behandelt werden?"
data[, 30] <- factor(data[, 30], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[30] <- "q_01_4"

# LimeSurvey Field type: F
data[, 31] <- as.numeric(data[, 31])
attributes(data)$variable.labels[31] <- "[SicherheitspolitikWP011 – FriedensparteiWP096 – [AG Außen- und Sicherheitspolitik Einleitung] Außen- und Sicherheitspolititisches ProgrammWP101 – [AG Außen- und Sicherheitspolitik] Transparente AußenpolitikWP116 – [AG Außen- und Sicherheitspolitik & AG Queeraten] Global Menschenrechte stärkenWP021 – Keine Kriege ausländischer Truppen von deutschem Gebiet aus ohne BundestagsmandatWP117 – [AG Außenpolitik] Gemeinsame Europäische Außen- und SicherheitspolitikWP100 – [AG Außen- und Sicherheitspolitik] Die Vereinten Nationen (UN)WP031 – Reform der IAEO (Internationalen Atomenergie Agentur)WP115 – [AG Außen- und Sicherheitspolitik] Piraten gegen CyberwarWP023 – Gegen jede Form von Cyberwar und CybercrimeWP017 – RüstungsexportkontrolleWP163 – [AG Außen- und Sicherheitspolitik] Verantwortungsbewusster RüstungsexportWP015 – Erweiterung der Ächtung von WaffenWP120 – [AG Außen- und Sicherheitspolitik] Schritte zur kernwaffenfreien WeltWP027 – Gefahr eines Atomkrieges reduzierenWP028 – Erfüllung des Atomwaffensperrvertrages auch durch originäre KernwaffenstaatenWP029 – Verhandlung über Kernwaffenkonvention beginnenWP030 – Beseitigung des Kriegsvorbehaltes bei Weiterverbreitung von Kernwaffen] Möchtest du, dass die folgenden Themen aus dem Bereich \"Außenpolitik\" behandelt werden?"
data[, 31] <- factor(data[, 31], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[31] <- "q_01_5"

# LimeSurvey Field type: F
data[, 32] <- as.numeric(data[, 32])
attributes(data)$variable.labels[32] <- "[SonstigesWP139 – Friedliche, nachhaltige und schonende Besiedlung des MarsWP140 – UTC als Standardzeit in Deutschland] Möchtest du, dass die folgenden Themen aus dem Bereich \"Außenpolitik\" behandelt werden?"
data[, 32] <- factor(data[, 32], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[32] <- "q_01_6"

# LimeSurvey Field type: F
data[, 33] <- as.numeric(data[, 33])
attributes(data)$variable.labels[33] <- "[Antrag WP] Nenne bis zu 8 Anträge aus dem Themenbereich \"Außenpolitik\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[33] <- "q_02_1"

# LimeSurvey Field type: F
data[, 34] <- as.numeric(data[, 34])
attributes(data)$variable.labels[34] <- "[Antrag WP] Nenne bis zu 8 Anträge aus dem Themenbereich \"Außenpolitik\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[34] <- "q_02_2"

# LimeSurvey Field type: F
data[, 35] <- as.numeric(data[, 35])
attributes(data)$variable.labels[35] <- "[Antrag WP] Nenne bis zu 8 Anträge aus dem Themenbereich \"Außenpolitik\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[35] <- "q_02_3"

# LimeSurvey Field type: F
data[, 36] <- as.numeric(data[, 36])
attributes(data)$variable.labels[36] <- "[Antrag WP] Nenne bis zu 8 Anträge aus dem Themenbereich \"Außenpolitik\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[36] <- "q_02_4"

# LimeSurvey Field type: F
data[, 37] <- as.numeric(data[, 37])
attributes(data)$variable.labels[37] <- "[Antrag WP] Nenne bis zu 8 Anträge aus dem Themenbereich \"Außenpolitik\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[37] <- "q_02_5"

# LimeSurvey Field type: F
data[, 38] <- as.numeric(data[, 38])
attributes(data)$variable.labels[38] <- "[Antrag WP] Nenne bis zu 8 Anträge aus dem Themenbereich \"Außenpolitik\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[38] <- "q_02_6"

# LimeSurvey Field type: F
data[, 39] <- as.numeric(data[, 39])
attributes(data)$variable.labels[39] <- "[Antrag WP] Nenne bis zu 8 Anträge aus dem Themenbereich \"Außenpolitik\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[39] <- "q_02_7"

# LimeSurvey Field type: F
data[, 40] <- as.numeric(data[, 40])
attributes(data)$variable.labels[40] <- "[Antrag WP] Nenne bis zu 8 Anträge aus dem Themenbereich \"Außenpolitik\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[40] <- "q_02_8"

# LimeSurvey Field type: F
data[, 41] <- as.numeric(data[, 41])
attributes(data)$variable.labels[41] <- "[ALG-II / Hartz-IVWP013 – Änderungen der Sozialgesetzgebung zum Arbeitsmarkt (SGB II, SGB III und IX) (sozialpolitisches Programm)] Möchtest du, dass die folgenden Themen aus dem Bereich \"Arbeit und Soziales\" behandelt werden?"
data[, 41] <- factor(data[, 41], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[41] <- "q_01_1"

# LimeSurvey Field type: F
data[, 42] <- as.numeric(data[, 42])
attributes(data)$variable.labels[42] <- "[Bedingungsloses GrundeinkommenWP009 – Bedingungsloses Grundeinkommen und Schritte dorthin (sozialpolitisches Programm)WP092 – Soziale Verantwortung und Solidarität] Möchtest du, dass die folgenden Themen aus dem Bereich \"Arbeit und Soziales\" behandelt werden?"
data[, 42] <- factor(data[, 42], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[42] <- "q_01_2"

# LimeSurvey Field type: F
data[, 43] <- as.numeric(data[, 43])
attributes(data)$variable.labels[43] <- "[ArbeitWP014 – Stärkung der Arbeitnehmerrechte (sozialpolitisches Programm)WP058 – Elternfreundliche Unternehmen und BetriebeWP020 – Menschen mit Behinderungen (sozialpolitisches Programm)WP153 – Forderung nach einem allgemeinen gesetzlichen Mindestlohn] Möchtest du, dass die folgenden Themen aus dem Bereich \"Arbeit und Soziales\" behandelt werden?"
data[, 43] <- factor(data[, 43], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[43] <- "q_01_3"

# LimeSurvey Field type: F
data[, 44] <- as.numeric(data[, 44])
attributes(data)$variable.labels[44] <- "[RenteWP018 – Alterssicherung (sozialpolitisches Programm)WP086 – Rente für das 21. JahrhundertWP059 – Stärkung der Gesetzlichen Rentenversicherung statt Förderung privater Rentenversicherungen] Möchtest du, dass die folgenden Themen aus dem Bereich \"Arbeit und Soziales\" behandelt werden?"
data[, 44] <- factor(data[, 44], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[44] <- "q_01_4"

# LimeSurvey Field type: F
data[, 45] <- as.numeric(data[, 45])
attributes(data)$variable.labels[45] <- "[CommonsWP090 – Commons (Gemeingüter): Vorfahrt für Kooperation, Selbstorganisation und Gemeinsinn] Möchtest du, dass die folgenden Themen aus dem Bereich \"Arbeit und Soziales\" behandelt werden?"
data[, 45] <- factor(data[, 45], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[45] <- "q_01_5"

# LimeSurvey Field type: F
data[, 46] <- as.numeric(data[, 46])
attributes(data)$variable.labels[46] <- "[SonstigesWP057 – Bekenntnis zum solidarischen und verteilungsgerechten Sozialstaat] Möchtest du, dass die folgenden Themen aus dem Bereich \"Arbeit und Soziales\" behandelt werden?"
data[, 46] <- factor(data[, 46], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[46] <- "q_01_6"

# LimeSurvey Field type: F
data[, 47] <- as.numeric(data[, 47])
attributes(data)$variable.labels[47] <- "[Antrag WP] Nenne bis zu 4 Anträge aus dem Themenbereich \"Arbeit und Soziales\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[47] <- "q_02_1"

# LimeSurvey Field type: F
data[, 48] <- as.numeric(data[, 48])
attributes(data)$variable.labels[48] <- "[Antrag WP] Nenne bis zu 4 Anträge aus dem Themenbereich \"Arbeit und Soziales\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[48] <- "q_02_2"

# LimeSurvey Field type: F
data[, 49] <- as.numeric(data[, 49])
attributes(data)$variable.labels[49] <- "[Antrag WP] Nenne bis zu 4 Anträge aus dem Themenbereich \"Arbeit und Soziales\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[49] <- "q_02_3"

# LimeSurvey Field type: F
data[, 50] <- as.numeric(data[, 50])
attributes(data)$variable.labels[50] <- "[Antrag WP] Nenne bis zu 4 Anträge aus dem Themenbereich \"Arbeit und Soziales\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[50] <- "q_02_4"

# LimeSurvey Field type: F
data[, 51] <- as.numeric(data[, 51])
attributes(data)$variable.labels[51] <- "[Forschung und WissenschaftWP067 – Angemessene Bezahlung für LehrbeauftragteWP045 – Bekenntnis zum Templiner ManifestWP152 – Forschungsförderung Wahlprogramm 2013WP046 – unbegrenzte Arbeitsmöglichkeiten für Akademiker- Änderung des Wissenschaftszeitvertragsgesetzes (WissZeitVG)] Möchtest du, dass die folgenden Themen aus dem Bereich \"Bildung und Forschung\" behandelt werden?"
data[, 51] <- factor(data[, 51], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[51] <- "q_01_1"

# LimeSurvey Field type: F
data[, 52] <- as.numeric(data[, 52])
attributes(data)$variable.labels[52] <- "[BildungspolitikWP128 – Wahlprogramm BildungWP132 – OER - Freie Bildungsmaterialien im Hochschulbereich] Möchtest du, dass die folgenden Themen aus dem Bereich \"Bildung und Forschung\" behandelt werden?"
data[, 52] <- factor(data[, 52], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[52] <- "q_01_2"

# LimeSurvey Field type: F
data[, 53] <- as.numeric(data[, 53])
attributes(data)$variable.labels[53] <- "[SonstigesWP141 – Zeitreisen] Möchtest du, dass die folgenden Themen aus dem Bereich \"Bildung und Forschung\" behandelt werden?"
data[, 53] <- factor(data[, 53], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[53] <- "q_01_3"

# LimeSurvey Field type: F
data[, 54] <- as.numeric(data[, 54])
attributes(data)$variable.labels[54] <- "[Antrag WP] Nenne bis zu 3 Anträge aus dem Themenbereich \"Bildung und Forschung\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[54] <- "q_02_1"

# LimeSurvey Field type: F
data[, 55] <- as.numeric(data[, 55])
attributes(data)$variable.labels[55] <- "[Antrag WP] Nenne bis zu 3 Anträge aus dem Themenbereich \"Bildung und Forschung\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[55] <- "q_02_2"

# LimeSurvey Field type: F
data[, 56] <- as.numeric(data[, 56])
attributes(data)$variable.labels[56] <- "[Antrag WP] Nenne bis zu 3 Anträge aus dem Themenbereich \"Bildung und Forschung\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[56] <- "q_02_3"

# LimeSurvey Field type: F
data[, 57] <- as.numeric(data[, 57])
attributes(data)$variable.labels[57] <- "[Umfassende AnträgeWP162 – Sammelantrag Internet und NetzpolitikWP142 – Restsammelantrag Netzpolitik] Möchtest du, dass die folgenden Themen aus dem Bereich \"Internet, Netzpolitik und Artverwandtes\" behandelt werden?"
data[, 57] <- factor(data[, 57], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[57] <- "q_01_1"

# LimeSurvey Field type: F
data[, 58] <- as.numeric(data[, 58])
attributes(data)$variable.labels[58] <- "[NetzneutralitätWP016 – Netzneutralität stärken und gesetzlich verankern] Möchtest du, dass die folgenden Themen aus dem Bereich \"Internet, Netzpolitik und Artverwandtes\" behandelt werden?"
data[, 58] <- factor(data[, 58], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[58] <- "q_01_2"

# LimeSurvey Field type: F
data[, 59] <- as.numeric(data[, 59])
attributes(data)$variable.labels[59] <- "[UrheberrechtWP097 – Reform des UrheberrechtsWP098 – Reform des UrheberrechtswahrnehmungsgesetzesWP099 – Weitere Informationen] Möchtest du, dass die folgenden Themen aus dem Bereich \"Internet, Netzpolitik und Artverwandtes\" behandelt werden?"
data[, 59] <- factor(data[, 59], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[59] <- "q_01_3"

# LimeSurvey Field type: F
data[, 60] <- as.numeric(data[, 60])
attributes(data)$variable.labels[60] <- "[DatenschutzWP084 – DatenschutzWP126 – Für einen modernen DatenschutzWP134 – Schmerzensgeldregelung im BundesdatenschutzgesetzWP145 – Schutz der Freiheit und Privatsphäre im Internet] Möchtest du, dass die folgenden Themen aus dem Bereich \"Internet, Netzpolitik und Artverwandtes\" behandelt werden?"
data[, 60] <- factor(data[, 60], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[60] <- "q_01_4"

# LimeSurvey Field type: F
data[, 61] <- as.numeric(data[, 61])
attributes(data)$variable.labels[61] <- "[E-MailWP007 – Ablehnung von De-MailWP004 – Ablehnung von DeMail (kürzer)WP102 – Rechtssichere E-Mail] Möchtest du, dass die folgenden Themen aus dem Bereich \"Internet, Netzpolitik und Artverwandtes\" behandelt werden?"
data[, 61] <- factor(data[, 61], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[61] <- "q_01_5"

# LimeSurvey Field type: F
data[, 62] <- as.numeric(data[, 62])
attributes(data)$variable.labels[62] <- "[JMStVWP019 – Jugendmedienschutz im Internet sichern, Medienkompetenz fördern] Möchtest du, dass die folgenden Themen aus dem Bereich \"Internet, Netzpolitik und Artverwandtes\" behandelt werden?"
data[, 62] <- factor(data[, 62], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[62] <- "q_01_6"

# LimeSurvey Field type: F
data[, 63] <- as.numeric(data[, 63])
attributes(data)$variable.labels[63] <- "[Antrag WP] Nenne bis zu 5 Anträge aus dem Themenbereich \"Internet, Netzpolitik und Artverwandtes\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[63] <- "q_02_1"

# LimeSurvey Field type: F
data[, 64] <- as.numeric(data[, 64])
attributes(data)$variable.labels[64] <- "[Antrag WP] Nenne bis zu 5 Anträge aus dem Themenbereich \"Internet, Netzpolitik und Artverwandtes\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[64] <- "q_02_2"

# LimeSurvey Field type: F
data[, 65] <- as.numeric(data[, 65])
attributes(data)$variable.labels[65] <- "[Antrag WP] Nenne bis zu 5 Anträge aus dem Themenbereich \"Internet, Netzpolitik und Artverwandtes\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[65] <- "q_02_3"

# LimeSurvey Field type: F
data[, 66] <- as.numeric(data[, 66])
attributes(data)$variable.labels[66] <- "[Antrag WP] Nenne bis zu 5 Anträge aus dem Themenbereich \"Internet, Netzpolitik und Artverwandtes\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[66] <- "q_02_4"

# LimeSurvey Field type: F
data[, 67] <- as.numeric(data[, 67])
attributes(data)$variable.labels[67] <- "[Antrag WP] Nenne bis zu 5 Anträge aus dem Themenbereich \"Internet, Netzpolitik und Artverwandtes\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[67] <- "q_02_5"

# LimeSurvey Field type: F
data[, 68] <- as.numeric(data[, 68])
attributes(data)$variable.labels[68] <- "[Familien- und GeschlechterpolitikWP131 – Gesamtkapitel Wahlprogramm \"Geschlechter- und Familienpolitik\"WP119 – Familien-politisches WahlprogrammWP165 – Sammelantrag Familie und GesellschaftWP147 – Pirate-LoveWP151 – Erhalt und Ausbau von Babyklappen] Möchtest du, dass die folgenden Themen aus dem Bereich \"Familie und Gesellschaft\" behandelt werden?"
data[, 68] <- factor(data[, 68], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[68] <- "q_01_1"

# LimeSurvey Field type: F
data[, 69] <- as.numeric(data[, 69])
attributes(data)$variable.labels[69] <- "[Migration und InklusionWP054 – Für die Vielfalt in der GesellschaftWP068 – Inklusion und Barrierefreiheit] Möchtest du, dass die folgenden Themen aus dem Bereich \"Familie und Gesellschaft\" behandelt werden?"
data[, 69] <- factor(data[, 69], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[69] <- "q_01_2"

# LimeSurvey Field type: F
data[, 70] <- as.numeric(data[, 70])
attributes(data)$variable.labels[70] <- "[AsylWP074 – Für eine solidarische Asylpolitik - Menschenrechte gelten für alle!] Möchtest du, dass die folgenden Themen aus dem Bereich \"Familie und Gesellschaft\" behandelt werden?"
data[, 70] <- factor(data[, 70], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[70] <- "q_01_3"

# LimeSurvey Field type: F
data[, 71] <- as.numeric(data[, 71])
attributes(data)$variable.labels[71] <- "[Antrag WP] Nenne bis zu 3 Anträge aus dem Themenbereich \"Familie und Gesellschaft\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[71] <- "q_02_1"

# LimeSurvey Field type: F
data[, 72] <- as.numeric(data[, 72])
attributes(data)$variable.labels[72] <- "[Antrag WP] Nenne bis zu 3 Anträge aus dem Themenbereich \"Familie und Gesellschaft\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[72] <- "q_02_2"

# LimeSurvey Field type: F
data[, 73] <- as.numeric(data[, 73])
attributes(data)$variable.labels[73] <- "[Antrag WP] Nenne bis zu 3 Anträge aus dem Themenbereich \"Familie und Gesellschaft\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[73] <- "q_02_3"

# LimeSurvey Field type: F
data[, 74] <- as.numeric(data[, 74])
attributes(data)$variable.labels[74] <- "[Umfassende AnträgeWP171 – Sammelantrag Wirtschaft und Finanzen] Möchtest du, dass die folgenden Themen aus dem Bereich \"Wirtschaft und Finanzen\" behandelt werden?"
data[, 74] <- factor(data[, 74], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[74] <- "q_01_1"

# LimeSurvey Field type: F
data[, 75] <- as.numeric(data[, 75])
attributes(data)$variable.labels[75] <- "[WirtschaftWP103 – Unternehmensgründung aktiv fördernWP143 – Stärkung der Gemeingüter und ein neuer WohlstandsbegriffWP129 – Nachhaltiges, faires, soziales und gerechtes WirtschaftssystemWP040 – Piratige Grundsätze in der Wirtschaftspolitik] Möchtest du, dass die folgenden Themen aus dem Bereich \"Wirtschaft und Finanzen\" behandelt werden?"
data[, 75] <- factor(data[, 75], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[75] <- "q_01_3"

# LimeSurvey Field type: F
data[, 76] <- as.numeric(data[, 76])
attributes(data)$variable.labels[76] <- "[HaushaltWP149 – Einführung des doppischen Haushalts‐ und Rechnungswesens auch auf allen Ebenen der Bundesrepublik Deutschland] Möchtest du, dass die folgenden Themen aus dem Bereich \"Wirtschaft und Finanzen\" behandelt werden?"
data[, 76] <- factor(data[, 76], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[76] <- "q_01_4"

# LimeSurvey Field type: F
data[, 77] <- as.numeric(data[, 77])
attributes(data)$variable.labels[77] <- "[SteuernWP064 – Internationale Steuergerechtigkeit und Bekämpfung von WirtschaftskriminalitätWP034 – Verschiedene Modulare Maßnahmen zur SteuerpolitikWP173 – Eckpunktepapier SteuerrechtWP033 – Steuerfreiheit des individuellen Existenzminimums für Menschen in besonderer LebenslageWP112 – Beseitigung der kalten Progression bei der EinkommenssteuerWP008 – Reform der Erbschaftsteuer statt VermögensteuerWP072 – Einführung einer BruttogeldvermögenssteuerWP026 – Reform der Lohn- und Einkommenssteuer] Möchtest du, dass die folgenden Themen aus dem Bereich \"Wirtschaft und Finanzen\" behandelt werden?"
data[, 77] <- factor(data[, 77], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[77] <- "q_01_5"

# LimeSurvey Field type: F
data[, 78] <- as.numeric(data[, 78])
attributes(data)$variable.labels[78] <- "[FinanzpolitikWP047 – Steuerzahler haften nicht für BankenWP051 – Trennung von Geschäfts- und InvestmentbankingWP037 – Banken und FinanzmarktregulierungWP091 – Eindämmung der Spekulation mit NahrungsmittelnWP081 – Keine Finanzspekulationen mit Nahrungsmitteln und Agrarrohstoffen] Möchtest du, dass die folgenden Themen aus dem Bereich \"Wirtschaft und Finanzen\" behandelt werden?"
data[, 78] <- factor(data[, 78], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[78] <- "q_01_6"

# LimeSurvey Field type: F
data[, 79] <- as.numeric(data[, 79])
attributes(data)$variable.labels[79] <- "[Transparenz und AntikorruptionWP052 – Transparenz der Vergabe öffentlicher AufträgeWP012 – Korruption im Wirtschaftsleben offenlegen und wirksam bekämpfen! (Integritätspaket)WP053 – Geschlossene und laufende Verträge der öffentlichen hand in einer intelligent strukturierten Datenbank offenlegenWP093 – Transparenz der Kosten bei privaten Rentenversicherungen] Möchtest du, dass die folgenden Themen aus dem Bereich \"Wirtschaft und Finanzen\" behandelt werden?"
data[, 79] <- factor(data[, 79], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[79] <- "q_01_7"

# LimeSurvey Field type: F
data[, 80] <- as.numeric(data[, 80])
attributes(data)$variable.labels[80] <- "[SonstigesWP003 – Für einen Paradigmenwechsel in der GeldpolitikWP044 – Mehr öffentliche Mittel für Bildung und Forschung] Möchtest du, dass die folgenden Themen aus dem Bereich \"Wirtschaft und Finanzen\" behandelt werden?"
data[, 80] <- factor(data[, 80], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[80] <- "q_01_8"

# LimeSurvey Field type: F
data[, 81] <- as.numeric(data[, 81])
attributes(data)$variable.labels[81] <- "[Antrag WP] Nenne bis zu 9 Anträge aus dem Themenbereich \"Wirtschaft und Finanzen\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[81] <- "q_02_1"

# LimeSurvey Field type: F
data[, 82] <- as.numeric(data[, 82])
attributes(data)$variable.labels[82] <- "[Antrag WP] Nenne bis zu 9 Anträge aus dem Themenbereich \"Wirtschaft und Finanzen\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[82] <- "q_02_2"

# LimeSurvey Field type: F
data[, 83] <- as.numeric(data[, 83])
attributes(data)$variable.labels[83] <- "[Antrag WP] Nenne bis zu 9 Anträge aus dem Themenbereich \"Wirtschaft und Finanzen\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[83] <- "q_02_3"

# LimeSurvey Field type: F
data[, 84] <- as.numeric(data[, 84])
attributes(data)$variable.labels[84] <- "[Antrag WP] Nenne bis zu 9 Anträge aus dem Themenbereich \"Wirtschaft und Finanzen\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[84] <- "q_02_4"

# LimeSurvey Field type: F
data[, 85] <- as.numeric(data[, 85])
attributes(data)$variable.labels[85] <- "[Antrag WP] Nenne bis zu 9 Anträge aus dem Themenbereich \"Wirtschaft und Finanzen\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[85] <- "q_02_5"

# LimeSurvey Field type: F
data[, 86] <- as.numeric(data[, 86])
attributes(data)$variable.labels[86] <- "[Antrag WP] Nenne bis zu 9 Anträge aus dem Themenbereich \"Wirtschaft und Finanzen\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[86] <- "q_02_6"

# LimeSurvey Field type: F
data[, 87] <- as.numeric(data[, 87])
attributes(data)$variable.labels[87] <- "[Antrag WP] Nenne bis zu 9 Anträge aus dem Themenbereich \"Wirtschaft und Finanzen\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[87] <- "q_02_7"

# LimeSurvey Field type: F
data[, 88] <- as.numeric(data[, 88])
attributes(data)$variable.labels[88] <- "[Antrag WP] Nenne bis zu 9 Anträge aus dem Themenbereich \"Wirtschaft und Finanzen\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[88] <- "q_02_8"

# LimeSurvey Field type: F
data[, 89] <- as.numeric(data[, 89])
attributes(data)$variable.labels[89] <- "[Antrag WP] Nenne bis zu 9 Anträge aus dem Themenbereich \"Wirtschaft und Finanzen\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[89] <- "q_02_9"

# LimeSurvey Field type: F
data[, 90] <- as.numeric(data[, 90])
attributes(data)$variable.labels[90] <- "[Umfassende AnträgeWP160 – Sammelantrag Freiheit und Grundrechte] Möchtest du, dass die folgenden Themen aus dem Bereich \"Freiheit und Grundrechte\" behandelt werden?"
data[, 90] <- factor(data[, 90], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[90] <- "q_01_1"

# LimeSurvey Field type: F
data[, 91] <- as.numeric(data[, 91])
attributes(data)$variable.labels[91] <- "[Informationelle SelbstbestimmungWP055 – Erweiterung 1.1.4 - Keine Fluggastdatenspeicherung!WP085 – Gegen Überwachungssoftware: Transparenz und Quellcode-Offenlegung] Möchtest du, dass die folgenden Themen aus dem Bereich \"Freiheit und Grundrechte\" behandelt werden?"
data[, 91] <- factor(data[, 91], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[91] <- "q_01_2"

# LimeSurvey Field type: F
data[, 92] <- as.numeric(data[, 92])
attributes(data)$variable.labels[92] <- "[ÜberwachungWP110 – Schutz der Privatsphäre im GrundgesetzWP082 – \"Digitale Netzwerke\" ins GrundgesetzWP113 – Keine Bundes- oder Staatstrojaner - Wahlprogramm] Möchtest du, dass die folgenden Themen aus dem Bereich \"Freiheit und Grundrechte\" behandelt werden?"
data[, 92] <- factor(data[, 92], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[92] <- "q_01_4"

# LimeSurvey Field type: F
data[, 93] <- as.numeric(data[, 93])
attributes(data)$variable.labels[93] <- "[ProstitutionWP104 – Stärkung der Rechte Prostituierter] Möchtest du, dass die folgenden Themen aus dem Bereich \"Freiheit und Grundrechte\" behandelt werden?"
data[, 93] <- factor(data[, 93], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[93] <- "q_01_5"

# LimeSurvey Field type: F
data[, 94] <- as.numeric(data[, 94])
attributes(data)$variable.labels[94] <- "[FanrechteWP005 – Piraten für FanrechteWP006 – Position der Piratenpartei zu Pyrotechnik] Möchtest du, dass die folgenden Themen aus dem Bereich \"Freiheit und Grundrechte\" behandelt werden?"
data[, 94] <- factor(data[, 94], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[94] <- "q_01_6"

# LimeSurvey Field type: F
data[, 95] <- as.numeric(data[, 95])
attributes(data)$variable.labels[95] <- "[SonstigesWP144 – Sicherheit in FreiheitWP124 – ILA – International Liberty Agreement] Möchtest du, dass die folgenden Themen aus dem Bereich \"Freiheit und Grundrechte\" behandelt werden?"
data[, 95] <- factor(data[, 95], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[95] <- "q_01_7"

# LimeSurvey Field type: F
data[, 96] <- as.numeric(data[, 96])
attributes(data)$variable.labels[96] <- "[Antrag WP] Nenne bis zu 4 Anträge aus dem Themenbereich \"Freiheit und Grundrechte\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[96] <- "q_02_1"

# LimeSurvey Field type: F
data[, 97] <- as.numeric(data[, 97])
attributes(data)$variable.labels[97] <- "[Antrag WP] Nenne bis zu 4 Anträge aus dem Themenbereich \"Freiheit und Grundrechte\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[97] <- "q_02_2"

# LimeSurvey Field type: F
data[, 98] <- as.numeric(data[, 98])
attributes(data)$variable.labels[98] <- "[Antrag WP] Nenne bis zu 4 Anträge aus dem Themenbereich \"Freiheit und Grundrechte\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[98] <- "q_02_3"

# LimeSurvey Field type: F
data[, 99] <- as.numeric(data[, 99])
attributes(data)$variable.labels[99] <- "[Antrag WP] Nenne bis zu 4 Anträge aus dem Themenbereich \"Freiheit und Grundrechte\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[99] <- "q_02_4"

# LimeSurvey Field type: F
data[, 100] <- as.numeric(data[, 100])
attributes(data)$variable.labels[100] <- "[Umfassende AnträgeWP166 – Sammelantrag Gesundheit] Möchtest du, dass die folgenden Themen aus dem Bereich \"Gesundheitspolitik\" behandelt werden?"
data[, 100] <- factor(data[, 100], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[100] <- "q_01_1"

# LimeSurvey Field type: F
data[, 101] <- as.numeric(data[, 101])
attributes(data)$variable.labels[101] <- "[GesundheitspolitikWP078 – GesundheitspolitikWP150 – Positivliste für MedikamenteWP070 – Sterbehilfe] Möchtest du, dass die folgenden Themen aus dem Bereich \"Gesundheitspolitik\" behandelt werden?"
data[, 101] <- factor(data[, 101], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[101] <- "q_01_2"

# LimeSurvey Field type: F
data[, 102] <- as.numeric(data[, 102])
attributes(data)$variable.labels[102] <- "[Drogen- und SuchtpolitikWP042 – Drogen- und suchtpolitisches Wahlprogramm der Piratenpartei] Möchtest du, dass die folgenden Themen aus dem Bereich \"Gesundheitspolitik\" behandelt werden?"
data[, 102] <- factor(data[, 102], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[102] <- "q_01_3"

# LimeSurvey Field type: F
data[, 103] <- as.numeric(data[, 103])
attributes(data)$variable.labels[103] <- "[PsycheWP001 – Verrückt ist auch normal!] Möchtest du, dass die folgenden Themen aus dem Bereich \"Gesundheitspolitik\" behandelt werden?"
data[, 103] <- factor(data[, 103], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[103] <- "q_01_4"

# LimeSurvey Field type: F
data[, 104] <- as.numeric(data[, 104])
attributes(data)$variable.labels[104] <- "[NichtraucherschutzWP056 – Haltung der Piratenpartei zum Nichtraucherschutz] Möchtest du, dass die folgenden Themen aus dem Bereich \"Gesundheitspolitik\" behandelt werden?"
data[, 104] <- factor(data[, 104], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[104] <- "q_01_5"

# LimeSurvey Field type: F
data[, 105] <- as.numeric(data[, 105])
attributes(data)$variable.labels[105] <- "[Antrag WP] Nenne bis zu 3 Anträge aus dem Themenbereich \"Gesundheitspolitik\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[105] <- "q_02_1"

# LimeSurvey Field type: F
data[, 106] <- as.numeric(data[, 106])
attributes(data)$variable.labels[106] <- "[Antrag WP] Nenne bis zu 3 Anträge aus dem Themenbereich \"Gesundheitspolitik\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[106] <- "q_02_2"

# LimeSurvey Field type: F
data[, 107] <- as.numeric(data[, 107])
attributes(data)$variable.labels[107] <- "[Antrag WP] Nenne bis zu 3 Anträge aus dem Themenbereich \"Gesundheitspolitik\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[107] <- "q_02_3"

# LimeSurvey Field type: F
data[, 108] <- as.numeric(data[, 108])
attributes(data)$variable.labels[108] <- "[Umfassende AnträgeWP164 – Sammelantrag Umwelt und Verbraucherschutz] Möchtest du, dass die folgenden Themen aus dem Bereich \"Umwelt und Verbraucherschutz\" behandelt werden?"
data[, 108] <- factor(data[, 108], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[108] <- "q_01_1"

# LimeSurvey Field type: F
data[, 109] <- as.numeric(data[, 109])
attributes(data)$variable.labels[109] <- "[AtommüllWP159 – Förderung der Erforschung und Entwicklung von Verfahren zum Abbau hochradioaktiven, langlebigen AtommüllsWP114 – Sofortige Einstellung der Suche nach einem \"Atomaren Endlager\"] Möchtest du, dass die folgenden Themen aus dem Bereich \"Umwelt und Verbraucherschutz\" behandelt werden?"
data[, 109] <- factor(data[, 109], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[109] <- "q_01_2"

# LimeSurvey Field type: F
data[, 110] <- as.numeric(data[, 110])
attributes(data)$variable.labels[110] <- "[Bauen und WohnenWP155 – Bauen und WohnenWP130 – Bezahlbaren Wohnraum sichernWP157 – Stadt- und Regionalplanung] Möchtest du, dass die folgenden Themen aus dem Bereich \"Umwelt und Verbraucherschutz\" behandelt werden?"
data[, 110] <- factor(data[, 110], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[110] <- "q_01_3"

# LimeSurvey Field type: F
data[, 111] <- as.numeric(data[, 111])
attributes(data)$variable.labels[111] <- "[Bauen und VerkehrWP043 – Verkehrs- und IndustrielärmemissionenWP077 – Gegen ein generelles Tempolimit] Möchtest du, dass die folgenden Themen aus dem Bereich \"Umwelt und Verbraucherschutz\" behandelt werden?"
data[, 111] <- factor(data[, 111], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[111] <- "q_01_4"

# LimeSurvey Field type: F
data[, 112] <- as.numeric(data[, 112])
attributes(data)$variable.labels[112] <- "[SonstigesWP172 – Risikovorsorge gegen Peak Oil (Rückgang der Ölförderung)] Möchtest du, dass die folgenden Themen aus dem Bereich \"Umwelt und Verbraucherschutz\" behandelt werden?"
data[, 112] <- factor(data[, 112], levels=c(1,2,3,4),labels=c("Ja, auf jeden Fall", "Eher ja", "Eher nein", "Nein, auf keinen Fall"))
names(data)[112] <- "q_01_5"

# LimeSurvey Field type: F
data[, 113] <- as.numeric(data[, 113])
attributes(data)$variable.labels[113] <- "[Antrag WP] Nenne bis zu 3 Anträge aus dem Themenbereich \"Umwelt und Verbraucherschutz\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[113] <- "q_02_1"

# LimeSurvey Field type: F
data[, 114] <- as.numeric(data[, 114])
attributes(data)$variable.labels[114] <- "[Antrag WP] Nenne bis zu 3 Anträge aus dem Themenbereich \"Umwelt und Verbraucherschutz\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[114] <- "q_02_2"

# LimeSurvey Field type: F
data[, 115] <- as.numeric(data[, 115])
attributes(data)$variable.labels[115] <- "[Antrag WP] Nenne bis zu 3 Anträge aus dem Themenbereich \"Umwelt und Verbraucherschutz\", die du in Neumarkt behandeln möchtest. Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen!"
names(data)[115] <- "q_02_3"

# LimeSurvey Field type: F
data[, 116] <- as.numeric(data[, 116])
attributes(data)$variable.labels[116] <- "[Gesamtanträge] 	Da der Schwerpunkt des Parteitags auf dem Wahlprogramm liegt, sind ca. 14 Stunden des Parteitags für die Wahlprogrammslots reserviert. Es handelt sich um 14 Slots: Gesamtanträge zum Wahlprogramm, Präambel, und dann die 12 Themenbereiche.	Angenommen für jeden der 14 Slots wäre erst einmal eine Stunde vorgesehen. Welchen Slot würdest du verlängern oder verkürzen?"
data[, 116] <- factor(data[, 116], levels=c(1,2,3,4,5),labels=c("viel länger", "länger", "genau richtig", "kürzer", "viel kürzer"))
names(data)[116] <- "q_01_1"

# LimeSurvey Field type: F
data[, 117] <- as.numeric(data[, 117])
attributes(data)$variable.labels[117] <- "[Präambel (3)] 	Da der Schwerpunkt des Parteitags auf dem Wahlprogramm liegt, sind ca. 14 Stunden des Parteitags für die Wahlprogrammslots reserviert. Es handelt sich um 14 Slots: Gesamtanträge zum Wahlprogramm, Präambel, und dann die 12 Themenbereiche.	Angenommen für jeden der 14 Slots wäre erst einmal eine Stunde vorgesehen. Welchen Slot würdest du verlängern oder verkürzen?"
data[, 117] <- factor(data[, 117], levels=c(1,2,3,4,5),labels=c("viel länger", "länger", "genau richtig", "kürzer", "viel kürzer"))
names(data)[117] <- "q_01_2"

# LimeSurvey Field type: F
data[, 118] <- as.numeric(data[, 118])
attributes(data)$variable.labels[118] <- "[Freiheit und Grundrechte (11)] 	Da der Schwerpunkt des Parteitags auf dem Wahlprogramm liegt, sind ca. 14 Stunden des Parteitags für die Wahlprogrammslots reserviert. Es handelt sich um 14 Slots: Gesamtanträge zum Wahlprogramm, Präambel, und dann die 12 Themenbereiche.	Angenommen für jeden der 14 Slots wäre erst einmal eine Stunde vorgesehen. Welchen Slot würdest du verlängern oder verkürzen?"
data[, 118] <- factor(data[, 118], levels=c(1,2,3,4,5),labels=c("viel länger", "länger", "genau richtig", "kürzer", "viel kürzer"))
names(data)[118] <- "q_01_3"

# LimeSurvey Field type: F
data[, 119] <- as.numeric(data[, 119])
attributes(data)$variable.labels[119] <- "[Demokratie wagen (11)] 	Da der Schwerpunkt des Parteitags auf dem Wahlprogramm liegt, sind ca. 14 Stunden des Parteitags für die Wahlprogrammslots reserviert. Es handelt sich um 14 Slots: Gesamtanträge zum Wahlprogramm, Präambel, und dann die 12 Themenbereiche.	Angenommen für jeden der 14 Slots wäre erst einmal eine Stunde vorgesehen. Welchen Slot würdest du verlängern oder verkürzen?"
data[, 119] <- factor(data[, 119], levels=c(1,2,3,4,5),labels=c("viel länger", "länger", "genau richtig", "kürzer", "viel kürzer"))
names(data)[119] <- "q_01_4"

# LimeSurvey Field type: F
data[, 120] <- as.numeric(data[, 120])
attributes(data)$variable.labels[120] <- "[Internet, Netzpolitik und Artverwandtes (14)] 	Da der Schwerpunkt des Parteitags auf dem Wahlprogramm liegt, sind ca. 14 Stunden des Parteitags für die Wahlprogrammslots reserviert. Es handelt sich um 14 Slots: Gesamtanträge zum Wahlprogramm, Präambel, und dann die 12 Themenbereiche.	Angenommen für jeden der 14 Slots wäre erst einmal eine Stunde vorgesehen. Welchen Slot würdest du verlängern oder verkürzen?"
data[, 120] <- factor(data[, 120], levels=c(1,2,3,4,5),labels=c("viel länger", "länger", "genau richtig", "kürzer", "viel kürzer"))
names(data)[120] <- "q_01_5"

# LimeSurvey Field type: F
data[, 121] <- as.numeric(data[, 121])
attributes(data)$variable.labels[121] <- "[Bildung und Forschung (7)] 	Da der Schwerpunkt des Parteitags auf dem Wahlprogramm liegt, sind ca. 14 Stunden des Parteitags für die Wahlprogrammslots reserviert. Es handelt sich um 14 Slots: Gesamtanträge zum Wahlprogramm, Präambel, und dann die 12 Themenbereiche.	Angenommen für jeden der 14 Slots wäre erst einmal eine Stunde vorgesehen. Welchen Slot würdest du verlängern oder verkürzen?"
data[, 121] <- factor(data[, 121], levels=c(1,2,3,4,5),labels=c("viel länger", "länger", "genau richtig", "kürzer", "viel kürzer"))
names(data)[121] <- "q_01_6"

# LimeSurvey Field type: F
data[, 122] <- as.numeric(data[, 122])
attributes(data)$variable.labels[122] <- "[Umwelt und Verbraucherschutz (9)] 	Da der Schwerpunkt des Parteitags auf dem Wahlprogramm liegt, sind ca. 14 Stunden des Parteitags für die Wahlprogrammslots reserviert. Es handelt sich um 14 Slots: Gesamtanträge zum Wahlprogramm, Präambel, und dann die 12 Themenbereiche.	Angenommen für jeden der 14 Slots wäre erst einmal eine Stunde vorgesehen. Welchen Slot würdest du verlängern oder verkürzen?"
data[, 122] <- factor(data[, 122], levels=c(1,2,3,4,5),labels=c("viel länger", "länger", "genau richtig", "kürzer", "viel kürzer"))
names(data)[122] <- "q_01_7"

# LimeSurvey Field type: F
data[, 123] <- as.numeric(data[, 123])
attributes(data)$variable.labels[123] <- "[Arbeit und Soziales(12)] 	Da der Schwerpunkt des Parteitags auf dem Wahlprogramm liegt, sind ca. 14 Stunden des Parteitags für die Wahlprogrammslots reserviert. Es handelt sich um 14 Slots: Gesamtanträge zum Wahlprogramm, Präambel, und dann die 12 Themenbereiche.	Angenommen für jeden der 14 Slots wäre erst einmal eine Stunde vorgesehen. Welchen Slot würdest du verlängern oder verkürzen?"
data[, 123] <- factor(data[, 123], levels=c(1,2,3,4,5),labels=c("viel länger", "länger", "genau richtig", "kürzer", "viel kürzer"))
names(data)[123] <- "q_01_8"

# LimeSurvey Field type: F
data[, 124] <- as.numeric(data[, 124])
attributes(data)$variable.labels[124] <- "[Familie und Gesellschaft (8)] 	Da der Schwerpunkt des Parteitags auf dem Wahlprogramm liegt, sind ca. 14 Stunden des Parteitags für die Wahlprogrammslots reserviert. Es handelt sich um 14 Slots: Gesamtanträge zum Wahlprogramm, Präambel, und dann die 12 Themenbereiche.	Angenommen für jeden der 14 Slots wäre erst einmal eine Stunde vorgesehen. Welchen Slot würdest du verlängern oder verkürzen?"
data[, 124] <- factor(data[, 124], levels=c(1,2,3,4,5),labels=c("viel länger", "länger", "genau richtig", "kürzer", "viel kürzer"))
names(data)[124] <- "q_01_9"

# LimeSurvey Field type: F
data[, 125] <- as.numeric(data[, 125])
attributes(data)$variable.labels[125] <- "[Gesundheitspolitik (7)] 	Da der Schwerpunkt des Parteitags auf dem Wahlprogramm liegt, sind ca. 14 Stunden des Parteitags für die Wahlprogrammslots reserviert. Es handelt sich um 14 Slots: Gesamtanträge zum Wahlprogramm, Präambel, und dann die 12 Themenbereiche.	Angenommen für jeden der 14 Slots wäre erst einmal eine Stunde vorgesehen. Welchen Slot würdest du verlängern oder verkürzen?"
data[, 125] <- factor(data[, 125], levels=c(1,2,3,4,5),labels=c("viel länger", "länger", "genau richtig", "kürzer", "viel kürzer"))
names(data)[125] <- "q_01_10"

# LimeSurvey Field type: F
data[, 126] <- as.numeric(data[, 126])
attributes(data)$variable.labels[126] <- "[Europa (5)] 	Da der Schwerpunkt des Parteitags auf dem Wahlprogramm liegt, sind ca. 14 Stunden des Parteitags für die Wahlprogrammslots reserviert. Es handelt sich um 14 Slots: Gesamtanträge zum Wahlprogramm, Präambel, und dann die 12 Themenbereiche.	Angenommen für jeden der 14 Slots wäre erst einmal eine Stunde vorgesehen. Welchen Slot würdest du verlängern oder verkürzen?"
data[, 126] <- factor(data[, 126], levels=c(1,2,3,4,5),labels=c("viel länger", "länger", "genau richtig", "kürzer", "viel kürzer"))
names(data)[126] <- "q_01_11"

# LimeSurvey Field type: F
data[, 127] <- as.numeric(data[, 127])
attributes(data)$variable.labels[127] <- "[Außenpolitik (24)] 	Da der Schwerpunkt des Parteitags auf dem Wahlprogramm liegt, sind ca. 14 Stunden des Parteitags für die Wahlprogrammslots reserviert. Es handelt sich um 14 Slots: Gesamtanträge zum Wahlprogramm, Präambel, und dann die 12 Themenbereiche.	Angenommen für jeden der 14 Slots wäre erst einmal eine Stunde vorgesehen. Welchen Slot würdest du verlängern oder verkürzen?"
data[, 127] <- factor(data[, 127], levels=c(1,2,3,4,5),labels=c("viel länger", "länger", "genau richtig", "kürzer", "viel kürzer"))
names(data)[127] <- "q_01_12"

# LimeSurvey Field type: F
data[, 128] <- as.numeric(data[, 128])
attributes(data)$variable.labels[128] <- "[Wirtschaft und Finanzen (26)] 	Da der Schwerpunkt des Parteitags auf dem Wahlprogramm liegt, sind ca. 14 Stunden des Parteitags für die Wahlprogrammslots reserviert. Es handelt sich um 14 Slots: Gesamtanträge zum Wahlprogramm, Präambel, und dann die 12 Themenbereiche.	Angenommen für jeden der 14 Slots wäre erst einmal eine Stunde vorgesehen. Welchen Slot würdest du verlängern oder verkürzen?"
data[, 128] <- factor(data[, 128], levels=c(1,2,3,4,5),labels=c("viel länger", "länger", "genau richtig", "kürzer", "viel kürzer"))
names(data)[128] <- "q_01_13"

# LimeSurvey Field type: F
data[, 129] <- as.numeric(data[, 129])
attributes(data)$variable.labels[129] <- "[Innen- und Rechtspolitik (11)] 	Da der Schwerpunkt des Parteitags auf dem Wahlprogramm liegt, sind ca. 14 Stunden des Parteitags für die Wahlprogrammslots reserviert. Es handelt sich um 14 Slots: Gesamtanträge zum Wahlprogramm, Präambel, und dann die 12 Themenbereiche.	Angenommen für jeden der 14 Slots wäre erst einmal eine Stunde vorgesehen. Welchen Slot würdest du verlängern oder verkürzen?"
data[, 129] <- factor(data[, 129], levels=c(1,2,3,4,5),labels=c("viel länger", "länger", "genau richtig", "kürzer", "viel kürzer"))
names(data)[129] <- "q_01_14"

# LimeSurvey Field type: F
data[, 130] <- as.numeric(data[, 130])
attributes(data)$variable.labels[130] <- "[Freiheit und Grundrechte] 	Es wird Samstag und Sonntag für das Wahlprogramm eingerechnet.	Hast du eine bestimmte Vorstellung, wann die einzelnen Themenbereiche behandelt werden sollen?"
data[, 130] <- factor(data[, 130], levels=c(1,2,3,4),labels=c("Samstag vormittag", "Samstag nachmittag", "Sonntag vormittag", "Sonntag nachmittag"))
names(data)[130] <- "q_02_1"

# LimeSurvey Field type: F
data[, 131] <- as.numeric(data[, 131])
attributes(data)$variable.labels[131] <- "[Demokratie wagen] 	Es wird Samstag und Sonntag für das Wahlprogramm eingerechnet.	Hast du eine bestimmte Vorstellung, wann die einzelnen Themenbereiche behandelt werden sollen?"
data[, 131] <- factor(data[, 131], levels=c(1,2,3,4),labels=c("Samstag vormittag", "Samstag nachmittag", "Sonntag vormittag", "Sonntag nachmittag"))
names(data)[131] <- "q_02_2"

# LimeSurvey Field type: F
data[, 132] <- as.numeric(data[, 132])
attributes(data)$variable.labels[132] <- "[Internet, Netzpolitik und Artverwandtes] 	Es wird Samstag und Sonntag für das Wahlprogramm eingerechnet.	Hast du eine bestimmte Vorstellung, wann die einzelnen Themenbereiche behandelt werden sollen?"
data[, 132] <- factor(data[, 132], levels=c(1,2,3,4),labels=c("Samstag vormittag", "Samstag nachmittag", "Sonntag vormittag", "Sonntag nachmittag"))
names(data)[132] <- "q_02_3"

# LimeSurvey Field type: F
data[, 133] <- as.numeric(data[, 133])
attributes(data)$variable.labels[133] <- "[Bildung und Forschung] 	Es wird Samstag und Sonntag für das Wahlprogramm eingerechnet.	Hast du eine bestimmte Vorstellung, wann die einzelnen Themenbereiche behandelt werden sollen?"
data[, 133] <- factor(data[, 133], levels=c(1,2,3,4),labels=c("Samstag vormittag", "Samstag nachmittag", "Sonntag vormittag", "Sonntag nachmittag"))
names(data)[133] <- "q_02_4"

# LimeSurvey Field type: F
data[, 134] <- as.numeric(data[, 134])
attributes(data)$variable.labels[134] <- "[Umwelt und Verbraucherschutz] 	Es wird Samstag und Sonntag für das Wahlprogramm eingerechnet.	Hast du eine bestimmte Vorstellung, wann die einzelnen Themenbereiche behandelt werden sollen?"
data[, 134] <- factor(data[, 134], levels=c(1,2,3,4),labels=c("Samstag vormittag", "Samstag nachmittag", "Sonntag vormittag", "Sonntag nachmittag"))
names(data)[134] <- "q_02_5"

# LimeSurvey Field type: F
data[, 135] <- as.numeric(data[, 135])
attributes(data)$variable.labels[135] <- "[Arbeit und Soziales] 	Es wird Samstag und Sonntag für das Wahlprogramm eingerechnet.	Hast du eine bestimmte Vorstellung, wann die einzelnen Themenbereiche behandelt werden sollen?"
data[, 135] <- factor(data[, 135], levels=c(1,2,3,4),labels=c("Samstag vormittag", "Samstag nachmittag", "Sonntag vormittag", "Sonntag nachmittag"))
names(data)[135] <- "q_02_6"

# LimeSurvey Field type: F
data[, 136] <- as.numeric(data[, 136])
attributes(data)$variable.labels[136] <- "[Familie und Gesellschaft] 	Es wird Samstag und Sonntag für das Wahlprogramm eingerechnet.	Hast du eine bestimmte Vorstellung, wann die einzelnen Themenbereiche behandelt werden sollen?"
data[, 136] <- factor(data[, 136], levels=c(1,2,3,4),labels=c("Samstag vormittag", "Samstag nachmittag", "Sonntag vormittag", "Sonntag nachmittag"))
names(data)[136] <- "q_02_7"

# LimeSurvey Field type: F
data[, 137] <- as.numeric(data[, 137])
attributes(data)$variable.labels[137] <- "[Gesundheitspolitik] 	Es wird Samstag und Sonntag für das Wahlprogramm eingerechnet.	Hast du eine bestimmte Vorstellung, wann die einzelnen Themenbereiche behandelt werden sollen?"
data[, 137] <- factor(data[, 137], levels=c(1,2,3,4),labels=c("Samstag vormittag", "Samstag nachmittag", "Sonntag vormittag", "Sonntag nachmittag"))
names(data)[137] <- "q_02_8"

# LimeSurvey Field type: F
data[, 138] <- as.numeric(data[, 138])
attributes(data)$variable.labels[138] <- "[Europa] 	Es wird Samstag und Sonntag für das Wahlprogramm eingerechnet.	Hast du eine bestimmte Vorstellung, wann die einzelnen Themenbereiche behandelt werden sollen?"
data[, 138] <- factor(data[, 138], levels=c(1,2,3,4),labels=c("Samstag vormittag", "Samstag nachmittag", "Sonntag vormittag", "Sonntag nachmittag"))
names(data)[138] <- "q_02_9"

# LimeSurvey Field type: F
data[, 139] <- as.numeric(data[, 139])
attributes(data)$variable.labels[139] <- "[Außenpolitik] 	Es wird Samstag und Sonntag für das Wahlprogramm eingerechnet.	Hast du eine bestimmte Vorstellung, wann die einzelnen Themenbereiche behandelt werden sollen?"
data[, 139] <- factor(data[, 139], levels=c(1,2,3,4),labels=c("Samstag vormittag", "Samstag nachmittag", "Sonntag vormittag", "Sonntag nachmittag"))
names(data)[139] <- "q_02_10"

# LimeSurvey Field type: F
data[, 140] <- as.numeric(data[, 140])
attributes(data)$variable.labels[140] <- "[Wirtschaft und Finanzen] 	Es wird Samstag und Sonntag für das Wahlprogramm eingerechnet.	Hast du eine bestimmte Vorstellung, wann die einzelnen Themenbereiche behandelt werden sollen?"
data[, 140] <- factor(data[, 140], levels=c(1,2,3,4),labels=c("Samstag vormittag", "Samstag nachmittag", "Sonntag vormittag", "Sonntag nachmittag"))
names(data)[140] <- "q_02_11"

# LimeSurvey Field type: F
data[, 141] <- as.numeric(data[, 141])
attributes(data)$variable.labels[141] <- "[Innen- und Rechtspolitik] 	Es wird Samstag und Sonntag für das Wahlprogramm eingerechnet.	Hast du eine bestimmte Vorstellung, wann die einzelnen Themenbereiche behandelt werden sollen?"
data[, 141] <- factor(data[, 141], levels=c(1,2,3,4),labels=c("Samstag vormittag", "Samstag nachmittag", "Sonntag vormittag", "Sonntag nachmittag"))
names(data)[141] <- "q_02_12"

#Field hidden

# LimeSurvey Field type: A
data[, 142] <- as.character(data[, 142])
attributes(data)$variable.labels[142] <- "[Antrag] 	Nenne nun bis zu 15 Anträge, die du gerne behandeln möchtest! Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen."
names(data)[142] <- "q_02_1"

# LimeSurvey Field type: A
data[, 143] <- as.character(data[, 143])
attributes(data)$variable.labels[143] <- "[Antrag] 	Nenne nun bis zu 15 Anträge, die du gerne behandeln möchtest! Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen."
names(data)[143] <- "q_02_2"

# LimeSurvey Field type: A
data[, 144] <- as.character(data[, 144])
attributes(data)$variable.labels[144] <- "[Antrag] 	Nenne nun bis zu 15 Anträge, die du gerne behandeln möchtest! Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen."
names(data)[144] <- "q_02_3"

# LimeSurvey Field type: A
data[, 145] <- as.character(data[, 145])
attributes(data)$variable.labels[145] <- "[Antrag] 	Nenne nun bis zu 15 Anträge, die du gerne behandeln möchtest! Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen."
names(data)[145] <- "q_02_4"

# LimeSurvey Field type: A
data[, 146] <- as.character(data[, 146])
attributes(data)$variable.labels[146] <- "[Antrag] 	Nenne nun bis zu 15 Anträge, die du gerne behandeln möchtest! Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen."
names(data)[146] <- "q_02_5"

# LimeSurvey Field type: A
data[, 147] <- as.character(data[, 147])
attributes(data)$variable.labels[147] <- "[Antrag] 	Nenne nun bis zu 15 Anträge, die du gerne behandeln möchtest! Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen."
names(data)[147] <- "q_02_6"

# LimeSurvey Field type: A
data[, 148] <- as.character(data[, 148])
attributes(data)$variable.labels[148] <- "[Antrag] 	Nenne nun bis zu 15 Anträge, die du gerne behandeln möchtest! Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen."
names(data)[148] <- "q_02_7"

# LimeSurvey Field type: A
data[, 149] <- as.character(data[, 149])
attributes(data)$variable.labels[149] <- "[Antrag] 	Nenne nun bis zu 15 Anträge, die du gerne behandeln möchtest! Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen."
names(data)[149] <- "q_02_8"

# LimeSurvey Field type: A
data[, 150] <- as.character(data[, 150])
attributes(data)$variable.labels[150] <- "[Antrag] 	Nenne nun bis zu 15 Anträge, die du gerne behandeln möchtest! Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen."
names(data)[150] <- "q_02_9"

# LimeSurvey Field type: A
data[, 151] <- as.character(data[, 151])
attributes(data)$variable.labels[151] <- "[Antrag] 	Nenne nun bis zu 15 Anträge, die du gerne behandeln möchtest! Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen."
names(data)[151] <- "q_02_10"

# LimeSurvey Field type: A
data[, 152] <- as.character(data[, 152])
attributes(data)$variable.labels[152] <- "[Antrag] 	Nenne nun bis zu 15 Anträge, die du gerne behandeln möchtest! Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen."
names(data)[152] <- "q_02_11"

# LimeSurvey Field type: A
data[, 153] <- as.character(data[, 153])
attributes(data)$variable.labels[153] <- "[Antrag] 	Nenne nun bis zu 15 Anträge, die du gerne behandeln möchtest! Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen."
names(data)[153] <- "q_02_12"

# LimeSurvey Field type: A
data[, 154] <- as.character(data[, 154])
attributes(data)$variable.labels[154] <- "[Antrag] 	Nenne nun bis zu 15 Anträge, die du gerne behandeln möchtest! Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen."
names(data)[154] <- "q_02_13"

# LimeSurvey Field type: A
data[, 155] <- as.character(data[, 155])
attributes(data)$variable.labels[155] <- "[Antrag] 	Nenne nun bis zu 15 Anträge, die du gerne behandeln möchtest! Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen."
names(data)[155] <- "q_02_14"

# LimeSurvey Field type: A
data[, 156] <- as.character(data[, 156])
attributes(data)$variable.labels[156] <- "[Antrag] 	Nenne nun bis zu 15 Anträge, die du gerne behandeln möchtest! Anträge, die dir besonders wichtig sind, kannst du auch zwei mal benennen."
names(data)[156] <- "q_02_15"

#Field hidden

# LimeSurvey Field type: F
data[, 157] <- as.numeric(data[, 157])
attributes(data)$variable.labels[157] <- "1. Wirst du zum Bundesparteitag in Neumarkt kommen?"
data[, 157] <- factor(data[, 157], levels=c(1,2,3),labels=c("Ja, ich komme.", "Nein, ich komme nicht.", "Ich weiß es noch nicht."))
names(data)[157] <- "q_02"

# LimeSurvey Field type: F
data[, 158] <- as.numeric(data[, 158])
attributes(data)$variable.labels[158] <- "[keine Zeit] 	1a. Aus welchen Gründen wirst du voraussichtlich nicht am Bundesparteitag in Neumarkt teilnehmen?"
data[, 158] <- factor(data[, 158], levels=c(1,0),labels=c("Ja", "Nicht Gewählt"))
names(data)[158] <- "q_03_1"

# LimeSurvey Field type: F
data[, 159] <- as.numeric(data[, 159])
attributes(data)$variable.labels[159] <- "[zu teuer] 	1a. Aus welchen Gründen wirst du voraussichtlich nicht am Bundesparteitag in Neumarkt teilnehmen?"
data[, 159] <- factor(data[, 159], levels=c(1,0),labels=c("Ja", "Nicht Gewählt"))
names(data)[159] <- "q_03_2"

# LimeSurvey Field type: F
data[, 160] <- as.numeric(data[, 160])
attributes(data)$variable.labels[160] <- "[fehlende Unterkunft] 	1a. Aus welchen Gründen wirst du voraussichtlich nicht am Bundesparteitag in Neumarkt teilnehmen?"
data[, 160] <- factor(data[, 160], levels=c(1,0),labels=c("Ja", "Nicht Gewählt"))
names(data)[160] <- "q_03_3"

# LimeSurvey Field type: F
data[, 161] <- as.numeric(data[, 161])
attributes(data)$variable.labels[161] <- "[fehlende Reisemöglichkeit] 	1a. Aus welchen Gründen wirst du voraussichtlich nicht am Bundesparteitag in Neumarkt teilnehmen?"
data[, 161] <- factor(data[, 161], levels=c(1,0),labels=c("Ja", "Nicht Gewählt"))
names(data)[161] <- "q_03_4"

# LimeSurvey Field type: A
data[, 162] <- as.character(data[, 162])
attributes(data)$variable.labels[162] <- "[Sonstiges] 	1a. Aus welchen Gründen wirst du voraussichtlich nicht am Bundesparteitag in Neumarkt teilnehmen?"
names(data)[162] <- "q_03_other"

# LimeSurvey Field type: F
data[, 163] <- as.numeric(data[, 163])
attributes(data)$variable.labels[163] <- "2. Wie wichtig ist dir eine Teilnahme am kommenden Bundesparteitag in Neumarkt?"
data[, 163] <- factor(data[, 163], levels=c(1,2,3,4,5),labels=c("unwichtig", "weniger wichtig", "wichtig", "sehr wichtig", "Enthaltung"))
names(data)[163] <- "q_04"

# LimeSurvey Field type: F
data[, 164] <- as.numeric(data[, 164])
attributes(data)$variable.labels[164] <- "3. Was hältst du prinzipiell davon, bei Bedarf den Bundesparteitag auf drei Tage zu verlängern?"
data[, 164] <- factor(data[, 164], levels=c(1,2,3,4,5,6),labels=c("sehr schlecht", "eher schlecht", "egal", "eher gut", "sehr gut", "Enthaltung"))
names(data)[164] <- "q_05"

# LimeSurvey Field type: F
data[, 165] <- as.numeric(data[, 165])
attributes(data)$variable.labels[165] <- "4. Welchem Landesverband gehörst Du an?"
data[, 165] <- factor(data[, 165], levels=c(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18),labels=c("Baden-Württemberg", "Bayern", "Berlin", "Brandenburg", "Bremen", "Hamburg", "Hessen", "Mecklenburg-Vorpommern", "Niedersachsen", "Nordrhein-Westfalen", "Rheinland-Pfalz", "Saarland", "Sachsen", "Sachsen-Anhalt", "Schleswig-Holstein", "Thüringen", "Auslandspirat", "keine Angabe"))
names(data)[165] <- "q_06"

# LimeSurvey Field type: F
data[, 166] <- as.numeric(data[, 166])
attributes(data)$variable.labels[166] <- "5. Wie alt bist du?"
names(data)[166] <- "q_07"

# LimeSurvey Field type: F
data[, 167] <- as.numeric(data[, 167])
attributes(data)$variable.labels[167] <- "6. Welchem Geschlecht fühlst du dich zugehörig?"
data[, 167] <- factor(data[, 167], levels=c(1,2,3,4,5,6,7),labels=c("weiblich", "männlich", "männlich und weiblich", "weder männlich noch weiblich", "Eichhörnchen", "finde keine der Antworten passend", "ich möchte keine Angabe machen"))
names(data)[167] <- "q_08"

# LimeSurvey Field type: A
data[, 168] <- as.character(data[, 168])
attributes(data)$variable.labels[168] <- "7. Willst Du uns sonst noch etwas sagen?"
names(data)[168] <- "q_09"

# Variable name was incorrect and was changed from 01_1 to q_01_1 .
# Variable name was incorrect and was changed from 01_2 to q_01_2 .
# Variable name was incorrect and was changed from 01_3 to q_01_3 .
# Variable name was incorrect and was changed from 01_4 to q_01_4 .
# Variable name was incorrect and was changed from 01_6 to q_01_6 .
# Variable name was incorrect and was changed from 01_7 to q_01_7 .
# Variable name was incorrect and was changed from 02_1 to q_02_1 .
# Variable name was incorrect and was changed from 02_2 to q_02_2 .
# Variable name was incorrect and was changed from 02_3 to q_02_3 .
# Variable name was incorrect and was changed from 02_4 to q_02_4 .
# Variable name was incorrect and was changed from 01_1 to q_01_1 .
# Variable name was incorrect and was changed from 01_2 to q_01_2 .
# Variable name was incorrect and was changed from 01_3 to q_01_3 .
# Variable name was incorrect and was changed from 01_4 to q_01_4 .
# Variable name was incorrect and was changed from 02_1 to q_02_1 .
# Variable name was incorrect and was changed from 02_2 to q_02_2 .
# Variable name was incorrect and was changed from 02_3 to q_02_3 .
# Variable name was incorrect and was changed from 02_4 to q_02_4 .
# Variable name was incorrect and was changed from 01_1 to q_01_1 .
# Variable name was incorrect and was changed from 01_2 to q_01_2 .
# Variable name was incorrect and was changed from 01_3 to q_01_3 .
# Variable name was incorrect and was changed from 02_1 to q_02_1 .
# Variable name was incorrect and was changed from 02_2 to q_02_2 .
# Variable name was incorrect and was changed from 01_1 to q_01_1 .
# Variable name was incorrect and was changed from 01_2 to q_01_2 .
# Variable name was incorrect and was changed from 01_3 to q_01_3 .
# Variable name was incorrect and was changed from 01_4 to q_01_4 .
# Variable name was incorrect and was changed from 01_5 to q_01_5 .
# Variable name was incorrect and was changed from 01_6 to q_01_6 .
# Variable name was incorrect and was changed from 02_1 to q_02_1 .
# Variable name was incorrect and was changed from 02_2 to q_02_2 .
# Variable name was incorrect and was changed from 02_3 to q_02_3 .
# Variable name was incorrect and was changed from 02_4 to q_02_4 .
# Variable name was incorrect and was changed from 02_5 to q_02_5 .
# Variable name was incorrect and was changed from 02_6 to q_02_6 .
# Variable name was incorrect and was changed from 02_7 to q_02_7 .
# Variable name was incorrect and was changed from 02_8 to q_02_8 .
# Variable name was incorrect and was changed from 01_1 to q_01_1 .
# Variable name was incorrect and was changed from 01_2 to q_01_2 .
# Variable name was incorrect and was changed from 01_3 to q_01_3 .
# Variable name was incorrect and was changed from 01_4 to q_01_4 .
# Variable name was incorrect and was changed from 01_5 to q_01_5 .
# Variable name was incorrect and was changed from 01_6 to q_01_6 .
# Variable name was incorrect and was changed from 02_1 to q_02_1 .
# Variable name was incorrect and was changed from 02_2 to q_02_2 .
# Variable name was incorrect and was changed from 02_3 to q_02_3 .
# Variable name was incorrect and was changed from 02_4 to q_02_4 .
# Variable name was incorrect and was changed from 01_1 to q_01_1 .
# Variable name was incorrect and was changed from 01_2 to q_01_2 .
# Variable name was incorrect and was changed from 01_3 to q_01_3 .
# Variable name was incorrect and was changed from 02_1 to q_02_1 .
# Variable name was incorrect and was changed from 02_2 to q_02_2 .
# Variable name was incorrect and was changed from 02_3 to q_02_3 .
# Variable name was incorrect and was changed from 01_1 to q_01_1 .
# Variable name was incorrect and was changed from 01_2 to q_01_2 .
# Variable name was incorrect and was changed from 01_3 to q_01_3 .
# Variable name was incorrect and was changed from 01_4 to q_01_4 .
# Variable name was incorrect and was changed from 01_5 to q_01_5 .
# Variable name was incorrect and was changed from 01_6 to q_01_6 .
# Variable name was incorrect and was changed from 02_1 to q_02_1 .
# Variable name was incorrect and was changed from 02_2 to q_02_2 .
# Variable name was incorrect and was changed from 02_3 to q_02_3 .
# Variable name was incorrect and was changed from 02_4 to q_02_4 .
# Variable name was incorrect and was changed from 02_5 to q_02_5 .
# Variable name was incorrect and was changed from 01_1 to q_01_1 .
# Variable name was incorrect and was changed from 01_2 to q_01_2 .
# Variable name was incorrect and was changed from 01_3 to q_01_3 .
# Variable name was incorrect and was changed from 02_1 to q_02_1 .
# Variable name was incorrect and was changed from 02_2 to q_02_2 .
# Variable name was incorrect and was changed from 02_3 to q_02_3 .
# Variable name was incorrect and was changed from 01_1 to q_01_1 .
# Variable name was incorrect and was changed from 01_3 to q_01_3 .
# Variable name was incorrect and was changed from 01_4 to q_01_4 .
# Variable name was incorrect and was changed from 01_5 to q_01_5 .
# Variable name was incorrect and was changed from 01_6 to q_01_6 .
# Variable name was incorrect and was changed from 01_7 to q_01_7 .
# Variable name was incorrect and was changed from 01_8 to q_01_8 .
# Variable name was incorrect and was changed from 02_1 to q_02_1 .
# Variable name was incorrect and was changed from 02_2 to q_02_2 .
# Variable name was incorrect and was changed from 02_3 to q_02_3 .
# Variable name was incorrect and was changed from 02_4 to q_02_4 .
# Variable name was incorrect and was changed from 02_5 to q_02_5 .
# Variable name was incorrect and was changed from 02_6 to q_02_6 .
# Variable name was incorrect and was changed from 02_7 to q_02_7 .
# Variable name was incorrect and was changed from 02_8 to q_02_8 .
# Variable name was incorrect and was changed from 02_9 to q_02_9 .
# Variable name was incorrect and was changed from 01_1 to q_01_1 .
# Variable name was incorrect and was changed from 01_2 to q_01_2 .
# Variable name was incorrect and was changed from 01_4 to q_01_4 .
# Variable name was incorrect and was changed from 01_5 to q_01_5 .
# Variable name was incorrect and was changed from 01_6 to q_01_6 .
# Variable name was incorrect and was changed from 01_7 to q_01_7 .
# Variable name was incorrect and was changed from 02_1 to q_02_1 .
# Variable name was incorrect and was changed from 02_2 to q_02_2 .
# Variable name was incorrect and was changed from 02_3 to q_02_3 .
# Variable name was incorrect and was changed from 02_4 to q_02_4 .
# Variable name was incorrect and was changed from 01_1 to q_01_1 .
# Variable name was incorrect and was changed from 01_2 to q_01_2 .
# Variable name was incorrect and was changed from 01_3 to q_01_3 .
# Variable name was incorrect and was changed from 01_4 to q_01_4 .
# Variable name was incorrect and was changed from 01_5 to q_01_5 .
# Variable name was incorrect and was changed from 02_1 to q_02_1 .
# Variable name was incorrect and was changed from 02_2 to q_02_2 .
# Variable name was incorrect and was changed from 02_3 to q_02_3 .
# Variable name was incorrect and was changed from 01_1 to q_01_1 .
# Variable name was incorrect and was changed from 01_2 to q_01_2 .
# Variable name was incorrect and was changed from 01_3 to q_01_3 .
# Variable name was incorrect and was changed from 01_4 to q_01_4 .
# Variable name was incorrect and was changed from 01_5 to q_01_5 .
# Variable name was incorrect and was changed from 02_1 to q_02_1 .
# Variable name was incorrect and was changed from 02_2 to q_02_2 .
# Variable name was incorrect and was changed from 02_3 to q_02_3 .
# Variable name was incorrect and was changed from 01_1 to q_01_1 .
# Variable name was incorrect and was changed from 01_2 to q_01_2 .
# Variable name was incorrect and was changed from 01_3 to q_01_3 .
# Variable name was incorrect and was changed from 01_4 to q_01_4 .
# Variable name was incorrect and was changed from 01_5 to q_01_5 .
# Variable name was incorrect and was changed from 01_6 to q_01_6 .
# Variable name was incorrect and was changed from 01_7 to q_01_7 .
# Variable name was incorrect and was changed from 01_8 to q_01_8 .
# Variable name was incorrect and was changed from 01_9 to q_01_9 .
# Variable name was incorrect and was changed from 01_10 to q_01_10 .
# Variable name was incorrect and was changed from 01_11 to q_01_11 .
# Variable name was incorrect and was changed from 01_12 to q_01_12 .
# Variable name was incorrect and was changed from 01_13 to q_01_13 .
# Variable name was incorrect and was changed from 01_14 to q_01_14 .
# Variable name was incorrect and was changed from 02_1 to q_02_1 .
# Variable name was incorrect and was changed from 02_2 to q_02_2 .
# Variable name was incorrect and was changed from 02_3 to q_02_3 .
# Variable name was incorrect and was changed from 02_4 to q_02_4 .
# Variable name was incorrect and was changed from 02_5 to q_02_5 .
# Variable name was incorrect and was changed from 02_6 to q_02_6 .
# Variable name was incorrect and was changed from 02_7 to q_02_7 .
# Variable name was incorrect and was changed from 02_8 to q_02_8 .
# Variable name was incorrect and was changed from 02_9 to q_02_9 .
# Variable name was incorrect and was changed from 02_10 to q_02_10 .
# Variable name was incorrect and was changed from 02_11 to q_02_11 .
# Variable name was incorrect and was changed from 02_12 to q_02_12 .
# Variable name was incorrect and was changed from 02_1 to q_02_1 .
# Variable name was incorrect and was changed from 02_2 to q_02_2 .
# Variable name was incorrect and was changed from 02_3 to q_02_3 .
# Variable name was incorrect and was changed from 02_4 to q_02_4 .
# Variable name was incorrect and was changed from 02_5 to q_02_5 .
# Variable name was incorrect and was changed from 02_6 to q_02_6 .
# Variable name was incorrect and was changed from 02_7 to q_02_7 .
# Variable name was incorrect and was changed from 02_8 to q_02_8 .
# Variable name was incorrect and was changed from 02_9 to q_02_9 .
# Variable name was incorrect and was changed from 02_10 to q_02_10 .
# Variable name was incorrect and was changed from 02_11 to q_02_11 .
# Variable name was incorrect and was changed from 02_12 to q_02_12 .
# Variable name was incorrect and was changed from 02_13 to q_02_13 .
# Variable name was incorrect and was changed from 02_14 to q_02_14 .
# Variable name was incorrect and was changed from 02_15 to q_02_15 .
# Variable name was incorrect and was changed from 02 to q_02 .
# Variable name was incorrect and was changed from 03_1 to q_03_1 .
# Variable name was incorrect and was changed from 03_2 to q_03_2 .
# Variable name was incorrect and was changed from 03_3 to q_03_3 .
# Variable name was incorrect and was changed from 03_4 to q_03_4 .
# Variable name was incorrect and was changed from 03_other to q_03_other .
# Variable name was incorrect and was changed from 04 to q_04 .
# Variable name was incorrect and was changed from 05 to q_05 .
# Variable name was incorrect and was changed from 06 to q_06 .
# Variable name was incorrect and was changed from 07 to q_07 .
# Variable name was incorrect and was changed from 08 to q_08 .
# Variable name was incorrect and was changed from 09 to q_09 .
