/*
 * Decompiled with CFR 0.152.
 */
package lqfbalarm.statistik;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.text.DateFormatter;
import lqfbalarm.Initiative;
import lqfbalarm.Initiativen;
import lqfbalarm.LQFBProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErgebnisStatistik {
    LQFBProperties props;
    Vector<Initiative> inis;
    HashMap<Integer, String> areaNames;

    public ErgebnisStatistik(LQFBProperties props) {
        this.props = props;
        this.areaNames = new HashMap();
    }

    public void loadStatistik(String scope) throws MalformedURLException, IOException {
        this.inis = new Vector();
        for (String anum : this.props.getAreas().split(",")) {
            Initiativen.parseInitiatives(new URL(this.props.getLQFBAPIPath() + "initiative.html?key=" + this.props.getDeveloperKey() + "&" + scope + "area_id=" + anum), this.inis, true, this.areaNames);
        }
        Vector<Initiative> newInis = new Vector<Initiative>();
        if (scope.equals("state=finished&")) {
            for (Initiative ini : this.inis) {
                if (ini.positive_votes <= 0) continue;
                newInis.add(ini);
            }
            this.inis = newInis;
        }
    }

    public HashMap<String, Integer> getUpcomingInitiatives() {
        HashMap<String, Integer> retval = new HashMap<String, Integer>();
        long smallest = System.currentTimeMillis();
        long longest = 0L;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy MM dd");
        for (Initiative ini : this.inis) {
            try {
                String day;
                long initime = ini.getDateForNextEvent().getTime();
                if (initime > longest) {
                    longest = initime;
                }
                if (retval.containsKey(day = formatter.format(new Date(initime)))) {
                    int count = retval.get(day) + 1;
                    retval.remove(day);
                    retval.put(day, count);
                    continue;
                }
                retval.put(day, 1);
            }
            catch (NullPointerException npe) {}
        }
        for (long i = smallest; i < longest; i += 86400000L) {
            Date day = new Date(i);
            String daystr = formatter.format(day);
            if (retval.containsKey(daystr)) continue;
            retval.put(daystr, 0);
        }
        return retval;
    }

    public HashMap<String, Integer> getCreatedInitiatives() {
        Object day;
        HashMap<String, Integer> retval = new HashMap<String, Integer>();
        long smallest = System.currentTimeMillis();
        long longest = 0L;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy MM dd");
        for (Initiative ini : this.inis) {
            if (ini.created.getTime() > longest) {
                longest = ini.created.getTime();
            }
            if (ini.created.getTime() < smallest) {
                smallest = ini.created.getTime();
            }
            if (retval.containsKey(day = formatter.format(ini.created))) {
                int count = retval.get(day) + 1;
                retval.remove(day);
                retval.put((String)day, count);
                continue;
            }
            retval.put((String)day, 1);
        }
        for (long i = smallest; i < longest; i += 86400000L) {
            day = new Date(i);
            String daystr = formatter.format((Date)day);
            if (retval.containsKey(daystr)) continue;
            retval.put(daystr, 0);
        }
        return retval;
    }

    public String getCSVFromCreatedInitiatives(HashMap<String, Integer> ci) {
        String retval = "";
        TreeSet<String> sortedset = new TreeSet<String>(ci.keySet());
        for (String current : sortedset) {
            retval = retval + current + "," + ci.get(current) + "\n";
            System.out.println(current);
        }
        return retval;
    }

    public String getWikiTable(boolean perArea) throws ParseException {
        DateFormatter df = new DateFormatter();
        Date d = new Date(System.currentTimeMillis());
        String current_area = "";
        String rank1_img = "[[Bild:Award_star_gold.png\u200e]]";
        String rank2_img = "[[Bild:Award_star_silver.png\u200e]]";
        String cross_img = "[[Bild:Cross.png\u200e]]";
        String date = df.valueToString(d);
        String retval = "=Ewige Hitparade im Bundes-LQFB der Piratenpartei DE=\n";
        retval = retval + "'''\u00dcber die kleinen Pfeile kannst Du die Tabelle selbst sortieren.'''\n";
        retval = retval + "''Achtung, bitte nicht editieren, diese Seite wird automatisch mit [[Benutzer:Andizo/LQFBAlarm]] neu generiert''\n";
        if (!perArea) {
            retval = retval + "{| class=\"wikitable sortable\" border=1 \n";
            retval = retval + "|+ Stand:''" + date + "''\n";
            retval = retval + "!Gebiet!";
            retval = retval + "!Datum !!Ini. !!Unterst. !!Pro !!Enth. !!Contra !!% Pro zu Basis !!% Pro zu Contra !!Rank !! class=\"unsortable\" |Name\n";
            retval = retval + "|-\n";
        }
        for (Initiative ini : this.inis) {
            int base = ini.issue_voter_count;
            int enthaltung = base - (ini.positive_votes + ini.negative_voters);
            double proprozent = (double)((int)((double)ini.positive_votes / (double)base * 10000.0)) / 100.0;
            double proprozentvscontra = (double)((int)((double)ini.positive_votes / (double)(base - enthaltung) * 10000.0)) / 100.0;
            double enthaltungprozent = (double)((int)((double)enthaltung / (double)base * 10000.0)) / 100.0;
            double negativeprozent = (double)((int)((double)ini.negative_voters / (double)base * 10000.0)) / 100.0;
            String proprozentstr = "" + proprozent;
            String proprozentbgcolor = "background-color:white";
            if (proprozent > 25.0) {
                proprozentbgcolor = "background-color:#ddffdd";
            }
            if (proprozent > 33.29) {
                proprozentbgcolor = "background-color:#ccffcc";
            }
            if (proprozent > 50.0) {
                proprozentbgcolor = "background-color:#aaffaa";
            }
            if (proprozent > 66.65) {
                proprozentbgcolor = "background-color:#80ff80";
            }
            if (proprozent > 75.0) {
                proprozentbgcolor = "background-color:#10ff10";
            }
            if (proprozent > 90.0) {
                proprozentbgcolor = "background-color:#00dd00";
            }
            if (proprozent < 10.0) {
                proprozentstr = "0" + proprozent;
            }
            while (proprozentstr.length() < 3) {
                proprozentstr = proprozentstr + ".";
            }
            while (proprozentstr.length() < 5) {
                proprozentstr = proprozentstr + "0";
            }
            String proprozentvscontrastr = "" + proprozentvscontra;
            if (proprozentvscontra < 10.0) {
                proprozentvscontrastr = "0" + proprozentvscontra;
            }
            while (proprozentvscontrastr.length() < 3) {
                proprozentvscontrastr = proprozentvscontrastr + ".";
            }
            while (proprozentvscontrastr.length() < 5) {
                proprozentvscontrastr = proprozentvscontrastr + "0";
            }
            String proprozentvscontrabgcolor = "background-color:white";
            if (proprozentvscontra > 10.0) {
                proprozentvscontrabgcolor = "background-color:#ddffdd";
            }
            if (proprozentvscontra > 33.29) {
                proprozentvscontrabgcolor = "background-color:#ccffcc";
            }
            if (proprozentvscontra > 50.0) {
                proprozentvscontrabgcolor = "background-color:#aaffaa";
            }
            if (proprozentvscontra > 66.65) {
                proprozentvscontrabgcolor = "background-color:#80ff80";
            }
            if (proprozentvscontra > 75.0) {
                proprozentvscontrabgcolor = "background-color:#10ff10";
            }
            if (proprozentvscontra > 75.0) {
                proprozentvscontrabgcolor = "background-color:#00dd00";
            }
            String rank_img = cross_img;
            if (ini.rank == 1) {
                rank_img = rank1_img;
            }
            if (ini.rank > 1) {
                rank_img = rank2_img;
            }
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy MM/dd HH:mm");
            if (perArea && !current_area.equals(ini.area_id + "")) {
                if (!current_area.equals("")) {
                    retval = retval + "|}\n";
                }
                retval = retval + "==Themengebiet " + ini.area_id + ": " + this.areaNames.get(ini.area_id) + "==\n";
                retval = retval + "{| class=\"wikitable sortable\" border=1 \n";
                retval = retval + "|+ Stand:''" + date + "''\n";
                retval = retval + "!Datum !!Ini. !!Unterst. !!Pro !!Enth. !!Contra !!% Pro zu Basis !!% Pro zu Contra !!Rank !! class=\"unsortable\" |Name\n";
                retval = retval + "|-\n";
            }
            current_area = ini.area_id + "";
            if (!perArea) {
                retval = retval + "| style=\"text-align:right\" |[" + this.props.getShortUrl() + "b" + ini.area_id + " " + ini.area_id + "]\n";
            }
            retval = retval + "| " + formatter.format(ini.issue_closed) + "\n";
            retval = retval + "| style=\"text-align:right\" |[" + this.props.getShortUrl() + "i" + ini.id + " " + ini.id + "]\n";
            retval = retval + "| style=\"text-align:right\" |" + ini.supporter_count + "\n";
            retval = retval + "| style=\"text-align:right\" |" + ini.positive_votes + "\n";
            retval = retval + "| style=\"text-align:right\" |" + (ini.issue_voter_count - ini.positive_votes - ini.negative_voters) + "\n";
            retval = retval + "| style=\"text-align:right\" |" + ini.negative_voters + "\n";
            retval = retval + "| style=\"text-align:right;" + proprozentbgcolor + "\" |" + proprozentstr + "\n";
            retval = retval + "| style=\"text-align:right;" + proprozentvscontrabgcolor + "\" |" + proprozentvscontrastr + "\n";
            retval = retval + "| style=\"text-align:right\" |" + ini.rank + " " + rank_img + "\n";
            retval = retval + "| " + ini.name + "\n";
            retval = retval + "|-\n";
        }
        retval = retval + "|}\n";
        return retval;
    }
}

