/*
 * Decompiled with CFR 0.152.
 */
package lqfbalarm;

import java.awt.Color;
import java.awt.Component;
import java.util.Calendar;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import lqfbalarm.AlarmScheduler;
import lqfbalarm.Initiative;
import lqfbalarm.Initiativen;
import lqfbalarm.LQFBProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpcomingEventsTableModel
extends DefaultTableCellRenderer
implements TableModel {
    Initiativen inis;
    LQFBProperties lqfbpropertries;
    AlarmScheduler alarmScheduler;
    JTextArea themenTextfeld;

    public UpcomingEventsTableModel(Initiativen inis, LQFBProperties lqfbproperties, AlarmScheduler alarmScheduler, JTextArea themenTextfeld) {
        this.themenTextfeld = themenTextfeld;
        this.inis = inis;
        this.lqfbpropertries = lqfbproperties;
        this.alarmScheduler = alarmScheduler;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component retval = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (row < 0) {
            return retval;
        }
        int myrow = table.getRowSorter().convertRowIndexToModel(row);
        Initiative myini = this.inis.initiativen.get(myrow);
        ((JLabel)retval).setToolTipText("<html><b>Thema:</b> " + this.getValueAt(myrow, 3) + "<br>" + this.getValueAt(myrow, 1) + "<br><b>Unterst\u00fctzer:</b>" + myini.supporter_count + "<br>" + this.getValueAt(myrow, 2).toString() + "</html>");
        if (isSelected) {
            return retval;
        }
        retval.setBackground(Color.white);
        if (column == 0 && ((String)this.getValueAt(myrow, 0)).contains(" 0d ")) {
            retval.setBackground(Color.yellow);
        }
        if (column == 0 && ((String)this.getValueAt(myrow, 0)).contains(" 0d 0")) {
            retval.setBackground(Color.orange);
        }
        if (column == 0 && ((String)this.getValueAt(myrow, 0)).contains(" 0d 00h")) {
            retval.setBackground(Color.red);
        }
        return retval;
    }

    @Override
    public int getRowCount() {
        return this.inis.initiativen.size();
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "Verbleibende Zeit";
        }
        if (columnIndex == 1) {
            return "Vorgang";
        }
        if (columnIndex == 2) {
            return "Name d. 1. Initiative";
        }
        if (columnIndex == 3) {
            return "Themen ID";
        }
        if (columnIndex == 4) {
            return "LeseZ";
        }
        if (columnIndex == 5) {
            return "Alarm";
        }
        if (columnIndex == 6) {
            return "Detail";
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 3) {
            return Integer.class;
        }
        if (columnIndex == 4 || columnIndex == 6) {
            return Boolean.class;
        }
        if (columnIndex == 5) {
            return Integer.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 4) {
            return true;
        }
        return columnIndex == 6;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Initiative ini = this.inis.initiativen.get(rowIndex);
        if (columnIndex == 0) {
            Calendar cal = Calendar.getInstance();
            long millis = ini.getDateForNextEvent().getTime() - System.currentTimeMillis();
            cal.setTimeInMillis(millis);
            int days = (int)(millis / 86400000L);
            int hours = (int)((millis - (long)days * 1000L * 60L * 60L * 24L) / 3600000L);
            int minutes = (int)((millis - (long)days * 1000L * 60L * 60L * 24L - (long)hours * 1000L * 60L * 60L) / 60000L);
            int seconds = (int)((millis - (long)days * 1000L * 60L * 60L * 24L - (long)hours * 1000L * 60L * 60L - (long)minutes * 1000L * 60L) / 1000L);
            if (hours < 0) {
                hours = 0;
            }
            if (minutes < 0) {
                minutes = 0;
            }
            if (seconds < 0) {
                seconds = 0;
            }
            String hoursstr = hours > 9 ? "" + hours : "0" + hours;
            String minutesstr = minutes > 9 ? "" + minutes : "0" + minutes;
            String secondsstr = seconds > 9 ? "" + seconds : "0" + seconds;
            String daysstring = "" + days;
            while (daysstring.length() < 4) {
                daysstring = " " + daysstring;
            }
            return daysstring + "d " + hoursstr + "h " + minutesstr + "m " + secondsstr + "s ";
        }
        if (columnIndex == 1) {
            return ini.nextEvent();
        }
        if (columnIndex == 2) {
            return ini.name;
        }
        if (columnIndex == 3) {
            return ini.issue_id;
        }
        if (columnIndex == 4) {
            return new Boolean(this.lqfbpropertries.getThemenGelesen(ini.issue_id, ini.getDateForNextEvent().getTime()));
        }
        if (columnIndex == 5) {
            return this.alarmScheduler.getNumberOfTweetsForIni(ini);
        }
        if (columnIndex == 6) {
            String[] detailthemen = this.lqfbpropertries.getThemes().split(",");
            String mythema = ini.issue_id + "";
            return this.lqfbpropertries.isThema(mythema);
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Initiative myini = this.inis.initiativen.get(rowIndex);
        if (columnIndex == 4) {
            this.lqfbpropertries.setThemenGelesen((Boolean)aValue, myini.issue_id, myini.getDateForNextEvent().getTime());
        }
        if (columnIndex == 6) {
            boolean dowatch = (Boolean)aValue;
            if (dowatch) {
                if (this.lqfbpropertries.getThemes().length() > 0) {
                    this.lqfbpropertries.setThemes(this.lqfbpropertries.getThemes() + "," + myini.issue_id);
                } else {
                    this.lqfbpropertries.setThemes(myini.issue_id + "");
                }
            } else {
                this.lqfbpropertries.removeThema(myini.issue_id + "");
            }
            this.themenTextfeld.setText(this.lqfbpropertries.getThemes());
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }
}

