/*
 * Decompiled with CFR 0.152.
 */
package lqfbalarm;

import java.awt.Color;
import java.awt.Component;
import java.text.SimpleDateFormat;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import lqfbalarm.Initiative;
import lqfbalarm.Initiativen;
import lqfbalarm.LQFBProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsTableModel
extends DefaultTableCellRenderer
implements TableModel {
    Initiativen inis;
    LQFBProperties lqfbprops;

    public NewsTableModel(Initiativen inis, LQFBProperties lqfbprops) {
        this.inis = inis;
        this.lqfbprops = lqfbprops;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int myrow = table.getRowSorter().convertRowIndexToModel(row);
        Initiative myini = this.inis.sonderThemen.get(myrow);
        Component retval = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        long timediff = System.currentTimeMillis() - this.inis.sonderThemen.get(myrow).dateForLastEvent().getTime();
        timediff /= 3600000L;
        String abstimmungErgebnis = "";
        if (myini.positive_votes > -1) {
            int base = myini.issue_voter_count;
            int enthaltung = base - (myini.positive_votes + myini.negative_voters);
            double proprozent = (double)((int)((double)myini.positive_votes / (double)base * 10000.0)) / 100.0;
            double enthaltungprozent = (double)((int)((double)enthaltung / (double)base * 10000.0)) / 100.0;
            double negativeprozent = (double)((int)((double)myini.negative_voters / (double)base * 10000.0)) / 100.0;
            abstimmungErgebnis = "<br><b>Ergebnis:</b> +" + myini.positive_votes + "/o" + enthaltung + "/-" + myini.negative_voters + " In %: " + proprozent + "%/ " + enthaltungprozent + "%/ " + negativeprozent + "%";
        }
        ((JLabel)retval).setToolTipText("<html><b>Initiative:</b> " + this.getValueAt(myrow, 3) + " <b>Thema:</b> " + myini.issue_id + "<br>" + this.getValueAt(myrow, 1) + "<br><b>Unterst\u00fctzer:</b>" + this.inis.sonderThemen.get((int)myrow).supporter_count + abstimmungErgebnis + "<br>" + this.getValueAt(myrow, 2).toString() + "</html>");
        if (isSelected) {
            return retval;
        }
        retval.setBackground(Color.white);
        if (column == 0 && timediff < 24L) {
            retval.setBackground(Color.yellow);
        }
        if (column == 0 && timediff < 10L) {
            retval.setBackground(Color.orange);
        }
        if (column == 0 && timediff < 1L) {
            retval.setBackground(Color.red);
        }
        return retval;
    }

    @Override
    public int getRowCount() {
        return this.inis.sonderThemen.size();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int arg0) {
        if (arg0 == 0) {
            return "Zeitpunkt";
        }
        if (arg0 == 1) {
            return "Ereignis";
        }
        if (arg0 == 2) {
            return "Name";
        }
        if (arg0 == 3) {
            return "Initiativen ID";
        }
        if (arg0 == 4) {
            return "LeseZ";
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int arg0) {
        if (arg0 == 3) {
            return Integer.class;
        }
        if (arg0 == 4) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int arg0, int arg1) {
        return arg1 == 4;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Initiative myini = this.inis.sonderThemen.get(row);
        if (col == 0) {
            SimpleDateFormat formatter = new SimpleDateFormat("yy MM/dd HH:mm");
            return formatter.format(myini.dateForLastEvent());
        }
        if (col == 1) {
            return myini.lastEvent();
        }
        if (col == 2) {
            return myini.name;
        }
        if (col == 3) {
            return myini.id;
        }
        if (col == 4) {
            return new Boolean(this.lqfbprops.getGelesen(myini.id, myini.dateForLastEvent().getTime()));
        }
        return "";
    }

    @Override
    public void setValueAt(Object arg0, int arg1, int arg2) {
        if (arg2 == 4) {
            Initiative myini = this.inis.sonderThemen.get(arg1);
            this.lqfbprops.setGelesen((Boolean)arg0, myini.id, myini.dateForLastEvent().getTime());
        }
    }

    @Override
    public void addTableModelListener(TableModelListener arg0) {
    }

    @Override
    public void removeTableModelListener(TableModelListener arg0) {
    }
}

