/*
 * Decompiled with CFR 0.152.
 */
package lqfbalarm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LQFBProperties {
    Properties props = new Properties();

    public LQFBProperties() throws FileNotFoundException, IOException {
        this.setLQFBAPIPath("https://lqfb.piratenpartei.de/pp/api/");
        this.setLQFBBrowserPath("https://lqfb.piratenpartei.de/pp/");
        this.setTwitterAccessToken("");
        this.setTwitterAccessTokenSecret("");
        this.setShortUrl("http://pplf.de/");
        this.setUpdateAllIntervall(600);
        this.setUpdateNewsIntervall(120);
        try {
            this.props.load(new FileInputStream(this.getStorePath()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean getGelesen(int id, long timestamp) {
        if (this.props.getProperty("Gelesen") == null) {
            this.props.setProperty("Gelesen", "");
        }
        String[] geleseneThemenStr = this.props.getProperty("Gelesen").split(",");
        Vector<String> geleseneThemen = new Vector<String>();
        for (String str : geleseneThemenStr) {
            geleseneThemen.add(str);
        }
        return geleseneThemen.contains(id + ":" + timestamp);
    }

    public void setGelesen(boolean value, int id, long timestamp) {
        if (this.props.getProperty("Gelesen") == null) {
            this.props.setProperty("Gelesen", "");
        }
        String[] geleseneThemenStr = this.props.getProperty("Gelesen").split(",");
        Vector<String> geleseneThemen = new Vector<String>();
        for (String str : geleseneThemenStr) {
            geleseneThemen.add(str);
        }
        if (value) {
            if (geleseneThemen.contains(id + ":" + timestamp)) {
                return;
            }
            this.props.setProperty("Gelesen", this.props.getProperty("Gelesen") + "," + id + ":" + timestamp);
        } else if (geleseneThemen.contains(id + ":" + timestamp)) {
            geleseneThemen.remove(geleseneThemen.indexOf(id + ":" + timestamp));
            String all = "";
            boolean first = true;
            for (String str : geleseneThemen) {
                if (first) {
                    all = str;
                    first = false;
                    continue;
                }
                all = all + "," + str;
            }
            this.props.setProperty("Gelesen", all);
        }
        try {
            this.store();
        }
        catch (IOException ex) {
            Logger.getLogger(LQFBProperties.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean getThemenGelesen(int id, long timestamp) {
        if (this.props.getProperty("ThemenGelesen") == null) {
            this.props.setProperty("ThemenGelesen", "");
        }
        String[] geleseneThemenStr = this.props.getProperty("ThemenGelesen").split(",");
        Vector<String> geleseneThemen = new Vector<String>();
        for (String str : geleseneThemenStr) {
            geleseneThemen.add(str);
        }
        return geleseneThemen.contains(id + ":" + timestamp);
    }

    public void setThemenGelesen(boolean value, int id, long timestamp) {
        if (this.props.getProperty("ThemenGelesen") == null) {
            this.props.setProperty("ThemenGelesen", "");
        }
        String[] geleseneThemenStr = this.props.getProperty("ThemenGelesen").split(",");
        Vector<String> geleseneThemen = new Vector<String>();
        for (String str : geleseneThemenStr) {
            geleseneThemen.add(str);
        }
        if (value) {
            if (geleseneThemen.contains(id + ":" + timestamp)) {
                return;
            }
            this.props.setProperty("ThemenGelesen", this.props.getProperty("ThemenGelesen") + "," + id + ":" + timestamp);
        } else if (geleseneThemen.contains(id + ":" + timestamp)) {
            geleseneThemen.remove(geleseneThemen.indexOf(id + ":" + timestamp));
            String all = "";
            boolean first = true;
            for (String str : geleseneThemen) {
                if (first) {
                    all = str;
                    first = false;
                    continue;
                }
                all = all + "," + str;
            }
            this.props.setProperty("ThemenGelesen", all);
        }
        try {
            this.store();
        }
        catch (IOException ex) {
            Logger.getLogger(LQFBProperties.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void load() throws FileNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(this.getStorePath());
        this.props.load(fis);
        fis.close();
    }

    public void store() throws IOException {
        this.props.store(new FileOutputStream(this.getStorePath()), "LQFB Alarm properties");
    }

    public File getStorePath() {
        return new File(System.getProperty("user.home") + System.getProperty("file.separator") + "lqfbalarm.cfg");
    }

    public String getAreas() {
        return this.props.getProperty("areas");
    }

    public void setAreas(String value) {
        this.props.setProperty("areas", value);
    }

    public String getThemes() {
        return this.props.getProperty("themes");
    }

    public void setThemes(String value) {
        Vector<Integer> sortVector = new Vector<Integer>();
        for (String singlevalue : value.split(",")) {
            try {
                int i = Integer.parseInt(singlevalue);
                if (sortVector.contains(i)) continue;
                sortVector.add(i);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        Collections.sort(sortVector);
        String newvalue = "";
        for (Integer i : sortVector) {
            newvalue = newvalue + "," + i.toString();
        }
        if (newvalue.length() > 0) {
            newvalue = newvalue.substring(1);
        }
        this.props.setProperty("themes", newvalue);
    }

    public String getDeveloperKey() {
        return this.props.getProperty("developerkey");
    }

    public void setDeveloperKey(String value) {
        this.props.setProperty("developerkey", value);
    }

    public String getLQFBAPIPath() {
        return this.props.getProperty("lqfbapipath");
    }

    public void setLQFBAPIPath(String value) {
        this.props.setProperty("lqfbapipath", value);
    }

    public String getLQFBBrowserPath() {
        return this.props.getProperty("lqfbbrowserpath");
    }

    public void setLQFBBrowserPath(String value) {
        this.props.setProperty("lqfbbrowserpath", value);
    }

    public void setTwitterAccessToken(String value) {
        this.props.setProperty("twitteraccesstoken", value);
    }

    public String getTwitterAccesToken() {
        return this.props.getProperty("twitteraccesstoken");
    }

    public void setTwitterAccessTokenSecret(String value) {
        this.props.setProperty("twitteraccesstokensecret", value);
    }

    public String getTwitterAccesTokenSecret() {
        return this.props.getProperty("twitteraccesstokensecret");
    }

    public String getShortUrl() {
        return this.props.getProperty("shorturl");
    }

    public void setShortUrl(String shorturl) {
        this.props.setProperty("shorturl", shorturl);
    }

    public int getUpdateNewsIntervall() {
        return Integer.parseInt(this.props.getProperty("updatenewsintervall"));
    }

    public void setUpdateNewsIntervall(int value) {
        this.props.setProperty("updatenewsintervall", "" + value);
    }

    public int getUpdateAllIntervall() {
        return Integer.parseInt(this.props.getProperty("updateallintervall"));
    }

    public void setUpdateAllIntervall(int value) {
        this.props.setProperty("updateallintervall", "" + value);
    }

    public boolean isThema(String detailthema) {
        String[] detailthemen;
        for (String thema : detailthemen = this.getThemes().split(",")) {
            if (!detailthema.equals(thema)) continue;
            return true;
        }
        return false;
    }

    public void removeThema(String detailthema) {
        this.setThemes(this.getThemes().replaceAll("," + detailthema + ",", ","));
        if (this.getThemes().startsWith(detailthema + ",")) {
            this.setThemes(this.getThemes().substring(this.getThemes().indexOf(",")));
        }
        if (this.getThemes().endsWith("," + detailthema)) {
            this.setThemes(this.getThemes().substring(0, this.getThemes().lastIndexOf(",")));
        }
    }
}

