/*
 * Decompiled with CFR 0.152.
 */
package lqfbalarm;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import lqfbalarm.Initiative;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitiativenParser
extends DefaultHandler {
    public Vector inis;
    Initiative currentInitiative;
    StringBuffer charBuff;
    Vector knownIssues;
    boolean allowIssueDuplicates;
    HashMap<Integer, String> areas;

    public InitiativenParser(Vector inis, boolean allowIssueDuplicates, HashMap<Integer, String> areas) {
        this.areas = areas;
        this.inis = inis;
        this.allowIssueDuplicates = allowIssueDuplicates;
        this.charBuff = new StringBuffer();
        this.knownIssues = new Vector();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.charBuff.append(ch, start, length);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("initiative")) {
            this.currentInitiative = new Initiative();
        }
        this.charBuff = new StringBuffer();
    }

    long myTimeParser(String str) {
        if (str.contains("days")) {
            String numberstr = str.substring(0, str.indexOf("days") - 1);
            return 86400L * Long.parseLong(numberstr);
        }
        if (str.contains(":")) {
            String[] splitted = str.split(":");
            return Integer.parseInt(splitted[0]) * 60 * 60 + Integer.parseInt(splitted[1]) * 60 + Integer.parseInt(splitted[2]);
        }
        return 0L;
    }

    Date myDateParser(String str) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return formatter.parse(str);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (qName.equals("id")) {
            this.currentInitiative.id = Integer.parseInt(this.charBuff.toString());
        }
        if (qName.equals("initiative") && this.currentInitiative != null && (this.allowIssueDuplicates || !this.knownIssues.contains(this.currentInitiative.issue_id))) {
            this.knownIssues.add(this.currentInitiative.issue_id);
            if (this.allowIssueDuplicates || this.currentInitiative.getDateForNextEvent() != null) {
                this.inis.add(this.currentInitiative);
            }
        }
        if (qName.equals("name")) {
            this.currentInitiative.name = this.charBuff.toString();
        }
        if (qName.equals("issue_state")) {
            this.currentInitiative.state = this.charBuff.toString();
        }
        if (qName.equals("issue_id")) {
            this.currentInitiative.issue_id = Integer.parseInt(this.charBuff.toString());
        }
        if (qName.equals("area_id")) {
            this.currentInitiative.area_id = Integer.parseInt(this.charBuff.toString());
        }
        if (qName.equals("area_name")) {
            this.areas.put(this.currentInitiative.area_id, this.charBuff.toString());
        }
        if (qName.equals("issue_admission_time")) {
            this.currentInitiative.issue_admission_time = this.myTimeParser(this.charBuff.toString());
        }
        if (qName.equals("issue_discussion_time")) {
            this.currentInitiative.issue_discussion_time = this.myTimeParser(this.charBuff.toString());
        }
        if (qName.equals("current_draft_created")) {
            this.currentInitiative.current_draft_created = this.myDateParser(this.charBuff.toString());
        }
        if (qName.equals("supporter_count")) {
            this.currentInitiative.supporter_count = Integer.parseInt(this.charBuff.toString());
        }
        try {
            if (qName.equals("issue_voter_count")) {
                this.currentInitiative.issue_voter_count = Integer.parseInt(this.charBuff.toString());
            }
            if (qName.equals("positive_votes")) {
                this.currentInitiative.positive_votes = Integer.parseInt(this.charBuff.toString());
            }
            if (qName.equals("negative_votes")) {
                this.currentInitiative.negative_voters = Integer.parseInt(this.charBuff.toString());
            }
            if (qName.equals("rank")) {
                this.currentInitiative.rank = Integer.parseInt(this.charBuff.toString());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (qName.equals("issue_verification_time")) {
            this.currentInitiative.issue_verification_time = this.myTimeParser(this.charBuff.toString());
        }
        if (qName.equals("issue_voting_time")) {
            this.currentInitiative.issue_voting_time = this.myTimeParser(this.charBuff.toString());
        }
        if (qName.equals("issue_created")) {
            this.currentInitiative.issue_created = this.myDateParser(this.charBuff.toString());
        }
        if (qName.equals("issue_accepted")) {
            this.currentInitiative.issue_accepted = this.myDateParser(this.charBuff.toString());
        }
        if (qName.equals("issue_half_frozen")) {
            this.currentInitiative.issue_half_frozen = this.myDateParser(this.charBuff.toString());
        }
        if (qName.equals("issue_fully_frozen")) {
            this.currentInitiative.issue_fully_frozen = this.myDateParser(this.charBuff.toString());
        }
        if (qName.equals("issue_closed")) {
            this.currentInitiative.issue_closed = this.myDateParser(this.charBuff.toString());
        }
        if (qName.equals("created")) {
            this.currentInitiative.created = this.myDateParser(this.charBuff.toString());
        }
        if (qName.equals("revoked")) {
            this.currentInitiative.revoked = this.myDateParser(this.charBuff.toString());
        }
    }
}

