/*
 * Decompiled with CFR 0.152.
 */
package lqfbalarm;

import java.util.Calendar;
import java.util.Date;

public class Initiative {
    public int id;
    public int rank;
    public int area_id;
    public String name;
    public String state;
    public int issue_id;
    public long issue_discussion_time;
    public long issue_admission_time;
    public long issue_verification_time;
    public long issue_voting_time;
    public int supporter_count;
    public int issue_voter_count = -1;
    public int positive_votes = -1;
    public int negative_voters = -1;
    public Date revoked;
    public Date created;
    public Date issue_created;
    public Date issue_accepted;
    public Date issue_half_frozen;
    public Date issue_fully_frozen;
    public Date issue_closed;
    public Date current_draft_created;
    public static final String lastVotingEnded = "Abstimmung beendet";
    public static final String lastVotingStarted = "Abstimmungsbeginn";
    public static final String lastFrozen = "Eingefroren";
    public static final String lastClosed = "Beendet";
    public static final String lastRevoked = "Zur\u00fcckgezogen";
    public static final String lastNeuerEntwurf = "Neuer Entwurf";
    public static final String lastErzeugt = "Neue Initiative";
    public static String nextEingefroren = "->Eingefroren";
    public static String nextAbstimmung = "->Abstimmung";
    public static String nextAbstimmungsende = "->Abstimmungsende";
    public static String nextAkzeptiert = "->Akzeptiert";

    public Date getDateForStartVoting() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.issue_created);
        Date retval = new Date(cal.getTimeInMillis() + this.issue_discussion_time * 1000L + this.issue_verification_time * 1000L);
        return retval;
    }

    public String lastEvent() {
        if (this.revoked != null) {
            return lastRevoked;
        }
        if (this.state.equals("finished")) {
            return lastVotingEnded;
        }
        if (this.issue_closed != null) {
            return lastClosed;
        }
        if (this.issue_fully_frozen != null) {
            return lastVotingStarted;
        }
        if (this.issue_half_frozen != null) {
            return lastFrozen;
        }
        if (Math.abs(this.created.getTime() - this.current_draft_created.getTime()) < 2000L) {
            return lastErzeugt;
        }
        return lastNeuerEntwurf;
    }

    public Date dateForLastEvent() {
        if (this.lastEvent().equals(lastRevoked)) {
            return this.revoked;
        }
        if (this.lastEvent().equals(lastFrozen)) {
            return this.issue_half_frozen;
        }
        if (this.lastEvent().equals(lastClosed)) {
            return this.issue_closed;
        }
        if (this.lastEvent().equals(lastVotingEnded)) {
            return this.issue_closed;
        }
        if (this.lastEvent().equals(lastVotingStarted)) {
            return this.issue_fully_frozen;
        }
        return this.current_draft_created;
    }

    public String nextEvent() {
        if (this.state.equals("new")) {
            return nextAkzeptiert;
        }
        if (this.state.equals("accepted")) {
            return nextEingefroren;
        }
        if (this.state.equals("frozen")) {
            return nextAbstimmung;
        }
        if (this.state.equals("voting")) {
            return nextAbstimmungsende;
        }
        return "";
    }

    public Date getDateForNextEvent() {
        Calendar cal = Calendar.getInstance();
        Date retval = null;
        if (this.nextEvent().equals(nextAkzeptiert)) {
            cal.setTime(this.issue_created);
            retval = new Date(cal.getTimeInMillis() + this.issue_admission_time * 1000L);
        }
        if (this.nextEvent().equals(nextAbstimmungsende)) {
            cal.setTime(this.issue_accepted);
            retval = new Date(cal.getTimeInMillis() + this.issue_discussion_time * 1000L + this.issue_verification_time * 1000L + this.issue_voting_time * 1000L);
        }
        if (this.nextEvent().equals(nextAbstimmung)) {
            cal.setTime(this.issue_accepted);
            retval = new Date(cal.getTimeInMillis() + this.issue_discussion_time * 1000L + this.issue_verification_time * 1000L);
        }
        if (this.nextEvent().equals(nextEingefroren)) {
            cal.setTime(this.issue_accepted);
            retval = new Date(cal.getTimeInMillis() + this.issue_discussion_time * 1000L);
        }
        return retval;
    }
}

