/*
 * Decompiled with CFR 0.152.
 */
package lqfbalarm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import lqfbalarm.Initiative;
import lqfbalarm.Initiativen;
import lqfbalarm.LQFBProperties;
import lqfbalarm.TweetJDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlarmScheduler
implements TableModel {
    Vector<Integer> alarmtypes;
    Vector<Integer> eventtypes;
    Vector<String> messages = new Vector();
    Vector<String> values = new Vector();
    LQFBProperties props;
    public static final int TWITTER_ALARM = 1;
    public static final int TIME_EVENT = 1;
    public static final int STATUS_EVENT = 2;

    public AlarmScheduler(LQFBProperties props) {
        this.alarmtypes = new Vector();
        this.eventtypes = new Vector();
        this.props = props;
    }

    public Vector<String> getMessages() {
        return this.messages;
    }

    public Vector<String> getValues() {
        return this.values;
    }

    public void addAlarm(String value, String msg, int eventtype, int alarmtype) {
        msg.replaceAll("\n", "");
        this.messages.add(msg);
        this.values.add(value);
        this.eventtypes.add(new Integer(eventtype));
        this.alarmtypes.add(new Integer(alarmtype));
        this.store();
    }

    public int getNumberOfTweetsForIni(Initiative ini) {
        int retval = 0;
        for (int i = 0; i < this.values.size(); ++i) {
            String value = this.values.get(i);
            String message = this.messages.get(i);
            String url = this.props.getShortUrl() + "t" + ini.issue_id;
            if (!value.startsWith(ini.id + ":") && !message.contains(url + " ") && !message.endsWith(url)) continue;
            ++retval;
        }
        return retval;
    }

    public File getTweetFile() {
        return new File(System.getProperty("user.home") + System.getProperty("file.separator") + "tweetlist.lqa");
    }

    public void store() {
        Properties myprops = new Properties();
        for (String value : this.values) {
            myprops.setProperty(value, this.messages.get(this.values.indexOf(value)));
            myprops.setProperty("ET_" + value, this.eventtypes.get(this.values.indexOf(value)).toString());
            myprops.setProperty("AT_" + value, this.alarmtypes.get(this.values.indexOf(value)).toString());
        }
        try {
            myprops.store(new FileOutputStream(this.getTweetFile()), "Tweets scheduled with LQFBAlarm");
        }
        catch (IOException ex) {
            Logger.getLogger(AlarmScheduler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void load() {
        Properties myprops;
        block3: {
            myprops = new Properties();
            try {
                myprops.load(new FileInputStream(this.getTweetFile()));
            }
            catch (Exception ex) {
                if (this.getTweetFile().exists()) break block3;
                this.store();
                Logger.getLogger(AlarmScheduler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        Set<Object> keys = myprops.keySet();
        for (Object key : keys) {
            String keystr = key.toString();
            if (keystr.startsWith("ET_") || keystr.startsWith("AT_")) continue;
            int eventtype = Integer.parseInt(myprops.getProperty("ET_" + keystr));
            int alarmtype = Integer.parseInt(myprops.getProperty("AT_" + keystr));
            this.addAlarm(key.toString(), myprops.getProperty(key.toString()), eventtype, alarmtype);
        }
    }

    public void checkAndTweet(Initiativen inis) {
        for (int i = 0; i < this.values.size(); ++i) {
            long time;
            int eventtype = this.eventtypes.get(i);
            int alarmtype = this.alarmtypes.get(i);
            String value = this.values.get(i);
            String message = this.messages.get(i);
            if (eventtype == 2) {
                int targetini = Integer.parseInt(value.split(":")[0]);
                String state = value.split(":")[1];
                for (int j = 0; j < 2; ++j) {
                    Vector<Initiative> myinis = inis.sonderThemen;
                    if (j == 0) {
                        myinis = inis.initiativen;
                    }
                    for (Initiative ini : myinis) {
                        if (ini.id != targetini || !ini.state.equals(state) || alarmtype != 1 || !TweetJDialog.tweet(this.props, message)) continue;
                        this.removeAlarm(i);
                        return;
                    }
                }
            }
            if (eventtype != 1 || (time = Long.parseLong(value)) >= System.currentTimeMillis() || alarmtype != 1 || !TweetJDialog.tweet(this.props, message)) continue;
            this.removeAlarm(i);
            return;
        }
    }

    public void removeAlarm(int i) {
        this.alarmtypes.remove(i);
        this.eventtypes.remove(i);
        this.values.remove(i);
        this.messages.remove(i);
        this.store();
    }

    @Override
    public int getRowCount() {
        return this.messages.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return "Alarmtyp";
        }
        if (col == 1) {
            return "Ausl\u00f6ser";
        }
        if (col == 2) {
            return "Wert";
        }
        if (col == 3) {
            return "Meldung";
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int arg0) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col >= 2;
    }

    @Override
    public Object getValueAt(int row, int col) {
        String retval = "";
        if (col == 0 && this.alarmtypes.get(row) == 1) {
            retval = "Twitter";
        }
        if (col == 1) {
            retval = this.eventtypes.get(row) == 2 ? "Status" : "Zeit";
        }
        if (col == 2) {
            retval = this.values.get(row);
            if (this.eventtypes.get(row) == 1) {
                Date d = new Date(Long.parseLong(retval));
                retval = d.toString();
            }
        }
        if (col == 3) {
            retval = this.messages.get(row);
        }
        return retval;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 2 && this.eventtypes.get(row) != 1) {
            this.values.set(row, value.toString());
        }
        if (col == 3) {
            this.messages.set(row, value.toString());
        }
    }

    @Override
    public void addTableModelListener(TableModelListener arg0) {
    }

    @Override
    public void removeTableModelListener(TableModelListener arg0) {
    }
}

