#!/usr/bin/env python3
# coding=UTF-8
###############################################################################
## vim: et ai ts=4
##
## Bitte erst ab der Stelle im Code, die mit 'Hier beginnt Ihr Code' markiert
## ist, eigenen Code einfuegen.

###############################################################################

Aufgabe = 9                    # Diesen Eintrag nicht veraendern,
                               # anderenfalls wird die Aufgabe nicht gewertet!!

Studenten = []                 # Initalisierung der Studentenliste

###############################################################################
## Bitte tragen Sie in die folgenden Variablen Ihre Gruppennummer und die
## Mitglieder Ihrer Gruppe ein. Bitte verwenden Sie KEINE Umlaute!

Gruppennummer = 3
# Syntax fuer die Angabe der Namen und Matrikelnummern der einzelen
# Gruppenmitglieder:
#
Studenten.append({'matnr':34653, 'nachname':"Haug", 'vorname':"Martin"})
# Studenten.append({'matnr':12346, 'nachname':"NACHNAME2", 'vorname':"VORNAME2"})
# Studenten.append({'matnr':12347, 'nachname':"NACHNAME3", 'vorname':"VORNAME3"})
# Studenten.append({'matnr':12348, 'nachname':"NACHNAME4", 'vorname':"VORNAME4"})
# Studenten.append({'matnr':12349, 'nachname':"NACHNAME5", 'vorname':"VORNAME5"})

###############################################################################
## Code fuer Aufgabe
import sys
import os.path
import linecache
import inspect
from middle import middle

# Globale Variablen
STEP = 0
PRINTVARS = []


def traceit(frame, event, trace_arg):
    global STEP

    # Fuer die Beschreibung der Events:
    # http://docs.python.org/3.2/library/sys.html
    # bei sys.settrace(tracefunc)
    if event == "line":
        STEP += 1

        # Name der Datei, welche die gerade auszufuehrende
        # Programmzeile enthaelt
        t_filename = frame.f_code.co_filename

        # Zeilennummer in der Datei 'filename' fuer die
        # gerade auszufuehrende Programmzeile
        t_lineno = frame.f_lineno

        # Dictionary mit den gerade gesetzten Variablen
        # (vor der Ausfuehrung der Programzeile 't_lineno')
        t_locals = frame.f_locals

        print_trace(t_filename, t_lineno, t_locals,delimiter=" | ")

    return traceit


def main(x, y, z, print_vars=None):
    assert isinstance(x, int)
    assert isinstance(y, int)
    assert isinstance(z, int)
    assert (print_vars == None) or isinstance(print_vars, list)

    # Listen sollte man niemals direkt als Defaultwert vorgeben!
    # Deshalb das Konstrukt mit None:
    global PRINTVARS
    if print_vars == None:
        print_vars = PRINTVARS
        assert isinstance(print_vars, list)
    else:
        PRINTVARS = print_vars
    global STEP

    # Programmschrittzaehler zurueck setzen
    STEP = 1

    # Überschriftenzeile bauen und drucken:
    header = ["Schritt", "Zeile"]
    header.extend(print_vars[:])
    header.append("RETURN")
    print(" | ".join(header))

    # Beim Tracen mit event == 'line' wird der Funktionsaufruf nicht mit
    # getraced, deshalb muss er manuell gedruckt werden (oder die traceit
    # Funktion um den event 'call' erweitert werden.)
    first_line = [repr(STEP), "def middle(%d, %d, %d)" % (x, y, z), ""]
    return_line = ["", ""]
    for var in print_vars:
        first_line.append("")
        return_line.append("")

    print(" | ".join(first_line))

    # Tracing einschalten
    sys.settrace(traceit)

    ret = middle(x, y, z)

    # Tracing ausschalten
    sys.settrace(None)

    # Aehnliches, was fuer die erste Zeile gilt, gilt auch fuer den
    # Rueckgabewert.
    return_line.append(repr(ret))
    print(" | ".join(return_line))

###############################################################################
## Hier beginnt Ihr Code

def testcase():
    ret = middle(1,2,3)
    assert ret == 2, "ret==%s"%ret
    ret = middle(1,3,2)
    assert ret == 2, "ret==%s"%ret
    ret = middle(2,1,3)
    assert ret == 2, "ret==%s"%ret
    ret = middle(2,3,1)
    assert ret == 2, "ret==%s"%ret
    ret = middle(3,1,2)
    assert ret == 2, "ret==%s"%ret
    ret = middle(3,2,1)
    assert ret == 2, "ret==%s"%ret

    ret = middle(-3,2,43654235245234321)
    assert ret == 2, "ret==%s"%ret
    ret = middle(-423542354233,-2,-1)
    assert ret == -2, "ret==%s"%ret
    ret = middle(5,3,6)
    assert ret == 5, "ret==%s"%ret

def print_trace(t_filename, t_lineno, t_locals, empty_str="?", print_vars=None, delimiter="|"):
    assert isinstance(t_filename, str) and os.path.isfile(t_filename)
    assert isinstance(t_lineno, int)
    assert isinstance(t_locals, dict)
    assert isinstance(empty_str, str)
    assert (print_vars == None) or isinstance(print_vars, list)
    assert isinstance(delimiter, str)
    assert isinstance(STEP,int)

    # Listen sollte man niemals direkt als Defaultwert vorgeben!
    # Deshalb das Konstrukt mit None:
    if print_vars == None:
        print_vars = PRINTVARS
        assert isinstance(print_vars, list)

    ## Hier beginnt ihr Code
    variablen = ""
    for var in print_vars:
        variablen += (str(t_locals[var]) if var in t_locals else empty_str) + delimiter
    print( str(STEP) + delimiter + linecache.getline(t_filename, t_lineno).lstrip().rstrip() + delimiter + variablen)

    ## TIP wegen event == 'line':
    # Drucken Sie zuerst die Variablen und dann die Zeile
    # mit dem Schritt und der Programmzeile

###############################################################################
## Bitte erst innerhalb des folgenden if Blocks Funktionen aufrufen.
## Werden ausserhalb dieses Blocks Funktionen aufgerufen, so wird die Aufgabe
## nicht gewertet.

if __name__ == '__main__':

    ## Der folgende Funktionsaufruf prueft die Eintraege der Variablen
    ## Studenten, Gruppennummer und Aufgabe und gibt die Werte tabelarisch
    ## auf dem Bildschirm aus oder loest einen Fehler aus, falls die Form
    ## der Eintraege nicht korrekt ist.
    from Grading.Grading import *
    Grading.CheckStudents(Studenten, Gruppennummer, Aufgabe)

    # Der Beispielaufruf unten soll eine Tabelle, ähnlich wie in Uebung08
    # Aufgabe 1.1.1 fuer den Aufruf der Funktion middle(1,2,3) erzeugen, wobei
    # nur die Variablen 'x' und 'm' beobachtete werden:
    #
    # Schritt | Zeile | x | m | RETURN
    # 1 | def middle(1, 2 , 3) | | |
    #   | | 1 | ? |
    # 2 |      assert isinstance(x, int) | | |
    #   | | 1 | ? |
    # ....
    #   | | | | | 2
    #
    # Die Ausgabe ist also in einem CSV Format. Als Tennzeichen wird der
    # Eintrag von 'delimiter' bei print_trace verwendet.  Ist eine der
    # Variablen, die Beobachtet werden sollen noch nicht gesetzt, dann wird
    # stattdessen der Eintrag von 'empty_str' ausgegeben.

    testcase()
    main(1, 2, 3, ["x", "m"])
    #main(2,1, 3, ["x","y", "z", "m"])
    
