var som_init = false;
var som_cur;
var som_a = [];
var som_q =
[
	{
		q: 'Soll das Land Hessen sparen, um eine Neuverschuldung zu vermeiden und seine Schuldenlast zu verringern?',
		y: 1,
		n: 0
	},
	{
		q: 'Hätte man einer freiwilligen Selbstverpflichtung der Regierung zum Sparen glauben können?',
		y: 0,
		n: 1
	},
	{
		q: 'Hätte auch ein einfaches Landesgesetz genügt, um das angestrebte Sparen gesetzlich zu regeln?',
		y: 0,
		n: 1
	},
	{
		q: 'Ist die Schuldenbremse auf Bundesebene, die ebenfalls ab 2020 keine Neuverschuldung mehr für die Bundesländer vorsieht, ausreichend?',
		y: 0,
		n: 1
	},
	{
		q: 'Wird die Klage des Landes Schleswig-Holsteins gegen die Bundesschuldenbremse Erfolg haben?',
		y: 0,
		n: 1
	},
	{
		q: 'Wird die Schuldenbremse an der Politik des Schuldenmachens etwas verändern?',
		y: 1,
		n: 0
	},
	{
		q: 'Kann die Schuldenbremse das Problem der Verschuldung lösen?',
		y: 1,
		n: 0
	},
	{
		q: 'Müssen bei Konjunkturschwächephasen und bei Naturkatastrophen Ausnahmen  von der Schuldenbremse möglich sein?',
		y: 1,
		n: 0
	},
	{
		q: 'Lässt die vorgeschlagene Änderung des Artikels 141 der hessischen Verfassung dem Landtag und der Landesregierung ausreichende Möglichkeiten, bei Bedarf trotzdem Schulden zu machen?',
		y: 1,
		n: 0
	},
	{
		q: 'Ist - bei drastischen finanziellen Einschnitten - wegen der möglichen Legitimation durch das Volk eine Schuldzuweisung durch die Politiker an den Bürger zu befürchten?',
		y: 0,
		n: 1
	}
];


function initSOM() {
	$("#pp_som-close-button").click(function() {
		hideSOM();
	});

	$("button.back").click(function() {
		//console.log("back");
		if (som_cur > 0) {
			som_cur--;
		}
		moveQuestion(400);
	});
	$("button.next").click(function() {
		//console.log("next "+som_cur+" "+som_q.length);
		if (som_cur < som_q.length-1) {
			som_cur++;
		} else {
			resultQuestion();
		}
		moveQuestion(-400);
	});

	$('input:radio').click(function() {
		//console.log("input click");
		if ($(this).parent().parent().hasClass("pp_som-region-left")) {
			//console.log(som_cur);
			//console.log(som_q.length);
			if (som_cur == 0) {
				$("#q_"+som_cur+" .next").removeAttr('disabled');
			} else if (som_cur < som_q.length) {
				$("#q_"+som_cur+" .back").removeAttr('disabled');
				$("#q_"+som_cur+" .next").removeAttr('disabled');
			} else {
				$("#q_"+som_cur+" .back").removeAttr('disabled');
			}
			som_a[som_cur] = $(this).val();
			//console.log(som_a);
		}
	});

	$(window).resize(function() {
		setSOM();
	});

	//som_init = true;
}

function showSOM(force) {
	if (window.location.pathname == "/content/schuldenbremse")
		force = true;

	if (!force)
		return false;

	if ($.browser.msie && $.browser.version.substr(0,1)<=7) {
		if (force)
			location.href = "/content/browser";
		return false;
	}

	var portal = "";
	portal += '<div id="pp_som-modal-overlay"></div>';
	portal += '<div id="pp_som-modal-window">';
	portal += '<div id="pp_som-close-button"></div>';

	portal += '<div id="pp_som-header">';
	portal += '<ul>';
	portal += '<li>Transparenz</li>';
	portal += '<li class="dot">•</li>';
	portal += '<li>Mitbestimmung</li>';
	portal += '<li class="dot">•</li>';
	portal += '<li>Freiheit</li>';
	portal += '<li class="dot">•</li>';
	portal += '<li>Bürgerrechte</li>';
	portal += '<li class="dot">•</li>';
	portal += '<li>Datenschutz</li>';
	portal += '<li class="dot">•</li>';
	portal += '<li>Privatsphäre</li>';
	portal += '<li class="dot">•</li>';
	portal += '<li>Bildung</li>';
	portal += '</ul>';
	portal += '</div>';

	var facts = "";
	facts += '<div class="pp_som-hessen-home"></div>';
	facts += '<div class="pp_som-facts"><h2>Informationen</h2>';
	facts += '<div id="pp_som-accordion">';
	facts += '<h3><a href="#">Die Schuldenbremse im Grundgesetz</a></h3>';
	facts += '<div>Der Bundestag hat 2009 das Grundgesetz geändert und dort eine Schuldenbremse für die Haushalte des Bundes und der Länder eingeführt. Ab 2020 sollen die Länder keine Kredite mehr aufnehmen dürfen, der Bund nur noch in geringem Maße. Ausnahmen können für konjunkturelle Schwächephasen und Katastrophenfälle vorgesehen werden.';
	facts += '<br /><br />Weitere Informationen:<br /><a href="http://www.bundestag.de/dokumente/analysen/2009/schuldenbremse.pdf">Bundestag (PDF)</a><br /><a href="http://www.bundesregierung.de/static/flash/schuldenbremse/index.html">Bundesregierung</a><br /><a href="http://de.wikipedia.org/wiki/Schuldenbremse_%28Deutschland%29">Wikipedia</a></div>';
	facts += '<h3><a href="#">Die Klage Schleswig-Holsteins dagegen</a></h3>';
	facts += '<div>Der Landtag in Schleswig-Holstein wehrt sich gegen diese Grundgesetzänderung und klagt dagegen beim Verfassungsgericht. Die "Schuldenbremse" verletze den Grundsatz der Finanzautonomie, die Bund und Länder selbstständig und voneinander unabhängig über ihre Finanzen entscheiden lässt (vgl. <a href="http://dejure.org/gesetze/GG/109.html">Art. 109 GG</a>).';
	facts += '<br /><br />Weitere Informationen:<br /><a href="http://www.rp-online.de/politik/deutschland/Klage-gegen-Schuldenbremse_aid_815925.html">Klage gegen Schuldenbremse (RP Online)</a><br /><a href="http://www.martin-kayenburg.de/baseportal/pages/pressemitteilungen_detail&Id==139">Ex-Landtagspräsident Schleswig-Holstein</a><br /><a href="http://www.sh.gruene-fraktion.de/cms/presse/dok/294/294638.klage_gegen_die_schuldenbremse_ein_armut.html">Grüne Fraktion Schleswig-Holstein</a></div>';
	facts += '<h3><a href="#">Die geplante Schuldenbremse in der hessischen Verfassung</a></h3>';
	facts += '<div>Bisher heißt es in <a href="http://lawww.de/hlv/Aktuell/hv_text.htm#141">Artikel 141</a> sinngemäß: Kredite dürfen nur bei außerordentlichem Bedarf und in der Regel nur für Investitionen per Gesetz aufgenommen werden. In der neuen Fassung ab 2020 heißt es, dass der Haushalt grundsätzlich ohne Kredite auszugleichen ist. Dann folgen Ausnahmen für Konjunkturschwächen und Katastrophenfälle.';
	facts += '<br /><br />Weitere Informationen:<br /><a href="http://www.wahlen.hessen.de/irj/Wahlen_Internet?cid=461540bf53e0495d3c49e4dd1feffa0d">Informationen des Wahlleiters</a><br /><a href="http://www.echo-online.de/nachrichten/landespolitik/schulden101123./Im-Wortlaut-Artikel-141;art175,1397977">Neuer Wortlaut Artikel 141 (Echo Online)</a></div>';
	facts += '<h3><a href="#">Die Begründung der Landesregierung dazu</a></h3>';
	facts += '<div>Die Hessische Landesregierung hält die Änderung des Grundgesetzes und den damit verbundenen Konsolidierungszwang im Sinne einer generationengerechten und nachhaltigen Finanzpolitik im Interesse unserer Kinder und Kindeskinder für alternativlos. Sie will zudem sicherstellen, dass die Einführung der Schuldengrenze nicht zu Lasten der hessischen Kommunen geht.';
	facts += '<br /><br />Weitere Informationen:<br /><a href="http://www.hessen.de/irj/HMdF_Internet?cid=a109849ec3f033d074baf430d4cff6e3">Schuldbremse in Hessen (hess. Finanzministerium)</a><br /><a href="http://www.hessen.de/irj/servlet/prt/portal/prtroot/slimp.CMReader/HMdF_15/HMdF_Internet/med/512/51230c10-2de3-b21f-012f-31e2389e4818,22222222-2222-2222-2222-222222222222,true">Information zur Volksabstimmung (PDF)</a></div>';
	facts += '<h3><a href="#">Die Pro-Argumente</a></h3>';
	facts += '<div><ul><li>Die Staatsverschuldung muss gestoppt werden, um künftige Generationen nicht weiter zu belasten</li><li>Wenn die Schuldenbremse im Grundgesetz vom Verfassungsgericht für nichtig erklärt wird, haben wir sie für Hessen trotzdem</li><li>Für Katastrophen und wirtschaftliche Schwächephasen gibt es Ausnahmen</li><li>Wir haben noch 9 Jahre Zeit um die Neuverschuldung auf Null zu reduzieren.</li></ul>';
	facts += 'Weitere Argumente:<br /><a href="http://wiki.piratenpartei.de/HE:Meinungsbilder/Schuldenbremse#Pro:_Ich_bin_f.C3.BCr_die_Aufnahme_der_Schuldenbremse_in_die_hess._Verfassung">Pro-Argumente im Piraten-Wiki</a><br /><a href="http://www.schuldenbremse.info/">Kampagnenseite der CDU</a><br /><a href="http://www.schuldenbremse-hessen.de/">Kampagnenseite der FDP</a></div>';
	facts += '<h3><a href="#">Die Contra-Argumente</a></h3>';
	facts += '<div><ul><li>Es gibt schon eine Schuldenbremse in der Verfassung, trotzdem macht die Politik Schulden</li><li>Mit der Änderung will sich Hessen nur die Möglichkeit sichern, die Ausnahmen  zu nutzen</li><li>Mit der Schuldenbremse werden Sparmaßnahmen im sozialen Bereich begründet und legitimiert</li><li>Wer es ernst meint, hört sofort mit dem Schuldenmachen auf, nicht erst 2020</li></ul>';
	facts += 'Weitere Argumente:<br /><a href="http://wiki.piratenpartei.de/HE:Meinungsbilder/Schuldenbremse#Contra:_Ich_bin_gegen_die_Aufnahme_der_Schuldenbremse_in_die_hess._Verfassung">Contra-Argumente im Piraten-Wiki</a><br /><a href="http://www.handlungsfaehiges-hessen.de/">Kampagnenseite des DGB</a><br /><a href="http://www.linksfraktion-hessen.de/cms/themen/positionen/2120-fuer-ein-soziale-und-gerechtes-hessen-nein-zur-schuldenbremse-.html">Fraktion die Linke Hessen</a><br /><a href="http://www.karrock.de/daf/2011/02/gut-gemeint-aber-nicht-gut-gemacht-details-zur-volksabstimmung-ueber-die-schuldenbremse-maerz-2011/">darmstädterFiltrat (Blog)</a><br /><a href="http://www.novo-argumente.com/magazin.php/novo_notizen/artikel/000797">NovoArgumente (Blog)</a></div>';
	facts += '</div>';
	facts += '</div>';

	var intro = "";
	intro += '<div class="pp_som-intro">';
	intro += '<h2>Fragebogen</h2>';
	intro += '<p>Der Hessische Landtag hat eine Änderung der Hessischen Landesverfassung zur Änderung des Artikels 141, gemeinhin unter dem Titel "Schuldenbremse" bekannt, beschlossen. Damit diese in Kraft treten kann, müssen wir Bürger in einer Abstimmung zustimmen.</p>';
	intro += '<p>Die Abstimmung findet gleichzeitig mit den Kommunalwahlen am 27. März statt. Wahlberechtigt sind wie bei den Landtagswahlen alle Deutschen, die in Hessen seit mindestens drei Monaten ihren Erstwohnsitz haben.</p>';
	intro += '<p>Mit diesem Schuld-o-mat wollen wir Dir eine Entscheidungshilfe für die Abstimmung geben. Wir haben in der rechten Spalte einige wichtige Fakten und Argumente zusammengestellt.</p>';
	intro += '<p>Du kannst dich jetzt durch einen Fragebogen klicken, der dir am Ende einen Vorschlag macht, wie du abstimmen könntest.</p>';
	intro += '<p>Auch hier gilt natürlich: Traue keinem Schuld-o-mat, Denk! Selbst! und Informiere Dich!</p>';
	intro += '<p><button onclick="javascript:startSOM();">Start</button></p>';
	intro += '</div>';

	var result = "";
	result += '<div id="pp_som-q_result" class="pp_som-region-left">';
	result += '<h2>Auswertung</h2>';
	result += '<table border="0">';
	result += '<tr><td>Frage 1</td><td id="q_r_0_t"></td><td id="q_r_0"></td><td>Frage 6</td><td id="q_r_5_t"></td><td id="q_r_5"></td></tr>';
	result += '<tr><td>Frage 2</td><td id="q_r_1_t"></td><td id="q_r_1"></td><td>Frage 7</td><td id="q_r_6_t"></td><td id="q_r_6"></td></tr>';
	result += '<tr><td>Frage 3</td><td id="q_r_2_t"></td><td id="q_r_2"></td><td>Frage 8</td><td id="q_r_7_t"></td><td id="q_r_7"></td></tr>';
	result += '<tr><td>Frage 4</td><td id="q_r_3_t"></td><td id="q_r_3"></td><td>Frage 9</td><td id="q_r_8_t"></td><td id="q_r_8"></td></tr>';
	result += '<tr><td>Frage 5</td><td id="q_r_4_t"></td><td id="q_r_4"></td><td>Frage 10</td><td id="q_r_9_t"></td><td id="q_r_9"></td></tr>';
	result += '</table>';
	result += '<p>Du hast <span id="pp_som-q_points"></span> von 10 Punkten erreicht.</p>';
	result += '<h3>Empfehlung</h3>';
	result += '<p id="pp_som-q_result_yy" class="pp_som-q_result">Du solltest der <b>Verfassungsänderung zustimmen</b>.</p>';
	result += '<p id="pp_som-q_result_y" class="pp_som-q_result">Du solltest der <b>Verfassungsänderung eher zustimmen</b>.</p>';
	result += '<p id="pp_som-q_result_yn" class="pp_som-q_result">Du hast keine klare <b>Präferenz zur Verfassungsänderung</b>.</p>';
	result += '<p id="pp_som-q_result_n" class="pp_som-q_result">Du solltest die <b>Verfassungsänderung eher ablehnen</b>.</p>';
	result += '<p id="pp_som-q_result_nn" class="pp_som-q_result">Du solltest die <b>Verfassungsänderung ablehnen</b>.</p>';
	result += '<h3>Hinweis</h3>';
	result += '<p>Dieser kleine Fragebogen stellt nur eine Entscheidungshilfe dar. Er ersetzt keinesfalls die persönliche Auseinandersetzung mit dem komplexen Thema der Schuldenbremse. Es gilt nach wie vor das piratige Motto: Denk! Selbst!</p>';
	result += '<h3>PIRATEN-Meinung</h3>';
	result += '<p>Die Mitglieder der hessischen Piratenpartei haben sich in einer repräsentativen Umfrage mit 64% gegen die Verfassungsänderung ausgesprochen. 30% waren dafür und 6% haben sich dabei enthalten (<a href="https://vote.piratenpartei-hessen.de/auswertung.php?id=45064">Auswertung</a>).</p>';
	result += '<p><button onclick="resetSOM();">Neustart</button></p>';
	result += '</div>';

	portal += '<div id="pp_som-content">';
	portal += facts;
	portal += '<div id="pp_som-survey">';
	portal += '<ul class="caroussel">';
	portal += '<li>'+intro+'</li>';
	for (var i=0; i<som_q.length; i++) {
		portal += '<li>'+buildQuestion(i)+'</li>';
	}
	portal += '<li>'+result+'</li>';
	portal += '</ul>';
	portal += '</div>';
	portal += '</div>';

	portal += '<div id="pp_som-linkbar">';
	portal += '<ul class="first">';
	portal += '<li>Bergstrasse</li>';
	portal += '<li class="dot">•</li>';
	portal += '<li>Darmstadt</li>';
	portal += '<li class="dot">•</li>';
	portal += '<li>Frankfurt</li>';
	portal += '<li class="dot">•</li>';
	portal += '<li>Gießen</li>';
	portal += '<li class="dot">•</li>';
	portal += '<li>Hochtaunuskreis</li>';
	portal += '<li class="dot">•</li>';
	portal += '<li>Kassel</li>';
	portal += '</ul>';
	portal += '<ul class="second">';
	portal += '<li>Main-Kinzig-Kreis</li>';
	portal += '<li class="dot">•</li>';
	portal += '<li>Marburg</li>';
	portal += '<li class="dot">•</li>';
	portal += '<li>Offenbach</li>';
	portal += '<li class="dot">•</li>';
	portal += '<li>Waldeck-Frankenberg</li>';
	portal += '<li class="dot">•</li>';
	portal += '<li>Wetterau</li>';
	portal += '<li class="dot">•</li>';
	portal += '<li>Wiesbaden</li>';
	portal += '</ul>';
	portal += '</div>';

	portal += '<div id="pp_som-footer">';
	portal += '<ul class="left">';
	portal += '<li><a href="javascript:void(0);" onclick="switchSOM2Portal();">Kommunalwahl</a></li>';
	portal += '<li class="corner">&nbsp;</li>';
	portal += '</ul>';
	portal += '<ul class="right">';
	portal += '<li class="corner">&nbsp;</li>';
	portal += '<li><a href="http://www.piratenpartei-hessen.de/kontakt">Kontakt</a></li>';
	portal += '<li class="spacer">|</li>';
	portal += '<li><a href="http://www.piratenpartei-hessen.de/presse">Presse</a></li>';
	portal += '<li class="spacer">|</li>';
	portal += '<li><a href="http://www.piratenpartei-hessen.de/impressum">Impressum</a></li>';
	portal += '</ul>';

	portal += '</div>';

	$("body").append(portal);
	$('select').selectmenu({
		transferClasses: false
	});

	setSOM();

	//hideNavbar();
	//hideTooltip();

	$("#pp_som-accordion").accordion({autoHeight: false});
	$("#pp_som-survey input").checkBox();

	if (!som_init)
		initSOM();
}

function switchSOM2Portal() {
	hideSOM();
	$("#pp_kw2011_portal-blockButton").trigger('click');
}

function setSOM() {
	var pos = $("#pp_som-modal-window").offset();
	if (pos.top < 30) {
		var margin = parseInt($("#pp_som-modal-window").css("margin-top"));
		margin += 30 - pos.top;
		$("#pp_som-modal-window").css("margin-top", margin);
	} else {
		$("#pp_som-modal-window").css("margin-top", -395);
	}
}

function hideSOM() {
	$("#pp_som-modal-overlay").remove();
	$("#pp_som-modal-window").remove();
}

function resetSOM() {
	$("#pp_som-content ul.caroussel").animate(
		{
			marginLeft: "0px"
		},
		400,
		function() {
			//console.log("done");
		}
	);
}

function startSOM() {
	//console.log("start som");
	som_cur = 0;
	som_a = [];
	$(":radio").removeAttr("checked");
	$("label.ui-radio-state-checked").removeClass("ui-radio-state-checked");
	$("span.ui-radio-state-checked").removeClass("ui-radio-state-checked");
	$("button.next").attr('disabled', 'disabled');
	moveQuestion(-400);
}

function moveQuestion(offset) {
	var marginleft = $("#pp_som-content ul.caroussel").css("marginLeft");
	marginleft = marginleft.replace(/px/g, "");
	marginleft = parseInt(marginleft);

	offset = marginleft + offset;

	$("#pp_som-content ul.caroussel").animate(
		{
			marginLeft: offset+"px"
		},
		400,
		function() {
			//console.log("done");
		}
	);
}

function resultQuestion() {
	var sum = 0;
	for (var i=0; i<som_a.length; i++) {
		var val = parseInt(som_a[i]);
		sum += val;
		if (val == 0)
			$("(#q_r_"+i).html(som_a[i]+" Punkte");
		else
			$("(#q_r_"+i).html(som_a[i]+" Punkt");
		$("(#q_r_"+i+"_t").removeClass("pp_som-yes");
		$("(#q_r_"+i+"_t").removeClass("pp_som-no");
		if (som_q[i].y == som_a[i]) {
			$("(#q_r_"+i+"_t").html("Ja");
			$("(#q_r_"+i+"_t").addClass("pp_som-yes");
		} else {
			$("(#q_r_"+i+"_t").html("Nein");
			$("(#q_r_"+i+"_t").addClass("pp_som-no");
		}
	}
	$("#pp_som-q_points").html(sum);
	$("p.pp_som-q_result").hide();
	switch (sum) {
		case 0:
		case 1:
		case 2:
			$("#pp_som-q_result_nn").show();
			break;
		case 3:
		case 4:
			$("#pp_som-q_result_n").show();
			break;
		case 5:
			$("#pp_som-q_result_yn").show();
			break;
		case 6:
		case 7:
			$("#pp_som-q_result_y").show();
			break;
		case 8:
		case 9:
		case 10:
			$("#pp_som-q_result_yy").show();
			break;
	}
}

function buildQuestion(q) {
	var html = "";

	html += '<div id="q_'+q+'" class="pp_som-region-left">';
	html += '<h2>Frage '+(q+1)+' von '+som_q.length+'</h2>';
	html += '<p class="pp_som-q">'+som_q[q].q+'</p>';
	html += '<div class="pp_som-c"><input type="radio" id="radio_'+q+'_1" name="radio_'+q+'" value="'+som_q[q].y+'" /><label for="radio_'+q+'_1">Ja</label></div>';
	html += '<div class="pp_som-c pp_som-s"><input type="radio" id="radio_'+q+'_2" name="radio_'+q+'" value="'+som_q[q].n+'" /><label for="radio_'+q+'_2">Nein</label></div>';
	html += '<p class="pp_som-b">';
	html += '<button class="back">Zurück</button><button class="next" disabled="disabled">Weiter</button>';
	html += '</p>';
	html += '</div>';

	return html;
}
